/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static IFile getFile(IEditorInput editorInput) {
        IFile file = (IFile)Adapters.adapt((Object)editorInput, IFile.class);
        if (file != null) {
            return file;
        }
        IResource resource = (IResource)Adapters.adapt((Object)editorInput, IResource.class);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        if (editorInput instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
                if (storage != null) {
                    file = (IFile)Adapters.adapt((Object)storage, IFile.class);
                }
            }
            catch (CoreException coreException) {}
        }
        return file;
    }

    public static IResource getResource(IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        IResource resource = (IResource)Adapters.adapt((Object)editorInput, IResource.class);
        if (resource != null) {
            return resource;
        }
        return (IResource)Adapters.adapt((Object)editorInput, IFile.class);
    }

    public static IEditorPart findEditor(IWorkbenchPage page, IFile file) {
        IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(file));
        if (editor != null) {
            return editor;
        }
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile editorFile;
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart part = ref.getEditor(false);
            if (part != null && (editorFile = ResourceUtil.getFile(part.getEditorInput())) != null && file.equals((Object)editorFile)) {
                return part;
            }
            ++n2;
        }
        return null;
    }

    public static IResource getResource(Object element) {
        return (IResource)Adapters.adapt((Object)element, IResource.class);
    }

    public static IFile getFile(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        ResourceMapping mapping = ResourceUtil.getResourceMapping(element);
        if (mapping != null) {
            return ResourceUtil.getFileFromResourceMapping(mapping);
        }
        IFile file = (IFile)Adapters.adapt((Object)element, IFile.class);
        if (file != null) {
            return file;
        }
        IResource resource = (IResource)Adapters.adapt((Object)element, IResource.class);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public static ResourceMapping getResourceMapping(Object element) {
        return (ResourceMapping)Adapters.adapt((Object)element, ResourceMapping.class);
    }

    private static IFile getFileFromResourceMapping(ResourceMapping mapping) {
        IResource resource = ResourceUtil.getResourceFromResourceMapping(mapping);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private static IResource getResourceFromResourceMapping(ResourceMapping mapping) {
        IResource[] resources;
        block5: {
            ResourceTraversal[] traversals;
            block4: {
                try {
                    traversals = mapping.getTraversals(null, null);
                    if (traversals.length == 1) break block4;
                    return null;
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "org.eclipse.ui.ide");
                    return null;
                }
            }
            ResourceTraversal traversal = traversals[0];
            resources = traversal.getResources();
            if (resources.length == 1) break block5;
            return null;
        }
        return resources[0];
    }

    @Deprecated
    public static <T> T getAdapter(Object element, Class<T> adapterType, boolean forceLoad) {
        return (T)Adapters.adapt((Object)element, adapterType, (boolean)forceLoad);
    }
}

