/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;

public class WordWrapAction
extends Action
implements IPropertyChangeListener {
    private IConsoleView fConsoleView = null;

    public WordWrapAction(IConsoleView consoleView) {
        super(ConsoleMessages.WordWrapAction_0);
        this.fConsoleView = consoleView;
        this.setToolTipText(ConsoleMessages.WordWrapAction_1);
        this.setHoverImageDescriptor(ConsolePluginImages.getImageDescriptor("IMG_LCL_WRAP"));
        this.setDisabledImageDescriptor(ConsolePluginImages.getImageDescriptor("IMG_DLCL_WRAP"));
        this.setImageDescriptor(ConsolePluginImages.getImageDescriptor("IMG_ELCL_WRAP"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IConsoleHelpContextIds.CONSOLE_WORD_WRAP_ACTION);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.applyPreferences();
    }

    public void run() {
        boolean enableWordWrap = this.isChecked();
        this.getPreferenceStore().setValue(IConsoleConstants.P_CONSOLE_WORD_WRAP, enableWordWrap);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (IConsoleConstants.P_CONSOLE_WORD_WRAP.equals(property)) {
            this.applyPreferences();
        }
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fConsoleView = null;
    }

    private void applyPreferences() {
        boolean enableWordWrap = this.getPreferenceStore().getBoolean(IConsoleConstants.P_CONSOLE_WORD_WRAP);
        this.setChecked(enableWordWrap);
        this.fConsoleView.setWordWrap(enableWordWrap);
    }

    private IPreferenceStore getPreferenceStore() {
        return ConsolePlugin.getDefault().getPreferenceStore();
    }
}

