/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

class SWTAccessibleDelegate
extends NSObject {
    static final String ACCESSIBLE_KEY = "Accessible";
    static final byte[] SWT_OBJECT;
    static Callback accessible2Args;
    static Callback accessible3Args;
    static Callback accessible4Args;
    static long proc2Args;
    static long proc3Args;
    static long proc4Args;
    Accessible accessible;
    long delegateJniRef;
    int childID;
    NSArray attributeNames = null;
    NSArray parameterizedAttributeNames = null;
    NSArray actionNames = null;

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
        Class<SWTAccessibleDelegate> clazz = SWTAccessibleDelegate.class;
        accessible2Args = new Callback(clazz, "accessibleProc", 2);
        proc2Args = accessible2Args.getAddress();
        accessible3Args = new Callback(clazz, "accessibleProc", 3);
        proc3Args = accessible3Args.getAddress();
        accessible4Args = new Callback(clazz, "accessibleProc", 4);
        proc4Args = accessible3Args.getAddress();
        String className = "SWTAccessibleDelegate";
        byte[] byArray2 = new byte[2];
        byArray2[0] = 42;
        byte[] types = byArray2;
        int size = C.PTR_SIZEOF;
        int align = C.PTR_SIZEOF == 4 ? 2 : 3;
        long cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_accessibilityActionNames, proc2Args, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityAttributeNames, proc2Args, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityParameterizedAttributeNames, proc2Args, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityIsIgnored, proc2Args, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityFocusedUIElement, proc2Args, "@:");
        OS.class_addMethod(cls, OS.sel_accessibilityAttributeValue_, proc3Args, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilityHitTest_, proc3Args, "@:{NSPoint}");
        OS.class_addMethod(cls, OS.sel_accessibilityIsAttributeSettable_, proc3Args, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilityActionDescription_, proc3Args, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilityPerformAction_, proc3Args, "@:@");
        OS.class_addMethod(cls, OS.sel_accessibilityAttributeValue_forParameter_, proc4Args, "@:@@");
        OS.class_addMethod(cls, OS.sel_accessibilitySetValue_forAttribute_, proc4Args, "@:@@");
        OS.objc_registerClassPair(cls);
    }

    public SWTAccessibleDelegate(Accessible accessible, int childID) {
        super(0L);
        this.accessible = accessible;
        this.childID = childID;
        this.alloc().init();
        this.delegateJniRef = OS.NewGlobalRef(this);
        if (this.delegateJniRef == 0L) {
            SWT.error(2);
        }
        OS.object_setInstanceVariable(this.id, SWT_OBJECT, this.delegateJniRef);
    }

    NSArray accessibilityActionNames() {
        if (this.actionNames != null) {
            return SWTAccessibleDelegate.retainedAutoreleased(this.actionNames);
        }
        this.actionNames = this.accessible.internal_accessibilityActionNames(this.childID);
        this.actionNames.retain();
        return SWTAccessibleDelegate.retainedAutoreleased(this.actionNames);
    }

    NSArray accessibilityAttributeNames() {
        if (this.attributeNames != null) {
            return SWTAccessibleDelegate.retainedAutoreleased(this.attributeNames);
        }
        this.attributeNames = this.accessible.internal_accessibilityAttributeNames(this.childID);
        this.attributeNames.retain();
        return SWTAccessibleDelegate.retainedAutoreleased(this.attributeNames);
    }

    id accessibilityAttributeValue(NSString attribute) {
        return this.accessible.internal_accessibilityAttributeValue(attribute, this.childID);
    }

    NSArray accessibilityParameterizedAttributeNames() {
        if (this.parameterizedAttributeNames != null) {
            return SWTAccessibleDelegate.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        this.parameterizedAttributeNames = this.accessible.internal_accessibilityParameterizedAttributeNames(this.childID);
        this.parameterizedAttributeNames.retain();
        return SWTAccessibleDelegate.retainedAutoreleased(this.parameterizedAttributeNames);
    }

    id accessibilityAttributeValue_forParameter(NSString attribute, id parameter) {
        return this.accessible.internal_accessibilityAttributeValue_forParameter(attribute, parameter, this.childID);
    }

    boolean accessibilityIsIgnored() {
        return this.accessible.internal_accessibilityIsIgnored(this.childID);
    }

    boolean accessibilityIsAttributeSettable(NSString attribute) {
        return this.accessible.internal_accessibilityIsAttributeSettable(attribute, this.childID);
    }

    id accessibilityHitTest(NSPoint point) {
        return this.accessible.internal_accessibilityHitTest(point, this.childID);
    }

    id accessibilityFocusedUIElement() {
        return this.accessible.internal_accessibilityFocusedUIElement(this.childID);
    }

    void accessibilityPerformAction(NSString action) {
        this.accessible.internal_accessibilityPerformAction(action, this.childID);
    }

    id accessibilityActionDescription(NSString action) {
        return this.accessible.internal_accessibilityActionDescription(action, this.childID);
    }

    void accessibilitySetValue_forAttribute(id value, NSString attribute) {
        this.accessible.internal_accessibilitySetValue_forAttribute(value, attribute, this.childID);
    }

    static NSArray retainedAutoreleased(NSArray inObject) {
        NSObject temp = inObject.retain();
        NSObject temp2 = new NSObject(temp.id).autorelease();
        return new NSArray(temp2.id);
    }

    static long accessibleProc(long id2, long sel) {
        SWTAccessibleDelegate swtAcc = SWTAccessibleDelegate.getAccessibleDelegate(id2);
        if (swtAcc == null) {
            return 0L;
        }
        if (sel == OS.sel_accessibilityAttributeNames) {
            NSArray retObject = swtAcc.accessibilityAttributeNames();
            return retObject == null ? 0L : retObject.id;
        }
        if (sel == OS.sel_accessibilityActionNames) {
            NSArray retObject = swtAcc.accessibilityActionNames();
            return retObject == null ? 0L : retObject.id;
        }
        if (sel == OS.sel_accessibilityParameterizedAttributeNames) {
            NSArray retObject = swtAcc.accessibilityParameterizedAttributeNames();
            return retObject == null ? 0L : retObject.id;
        }
        if (sel == OS.sel_accessibilityIsIgnored) {
            boolean retVal = swtAcc.accessibilityIsIgnored();
            return retVal ? 1 : 0;
        }
        if (sel == OS.sel_accessibilityFocusedUIElement) {
            id retObject = swtAcc.accessibilityFocusedUIElement();
            return retObject == null ? 0L : retObject.id;
        }
        return 0L;
    }

    static long accessibleProc(long id2, long sel, long arg0) {
        SWTAccessibleDelegate swtAcc = SWTAccessibleDelegate.getAccessibleDelegate(id2);
        if (swtAcc == null) {
            return 0L;
        }
        if (sel == OS.sel_accessibilityAttributeValue_) {
            NSString attribute = new NSString(arg0);
            id retObject = swtAcc.accessibilityAttributeValue(attribute);
            return retObject == null ? 0L : retObject.id;
        }
        if (sel == OS.sel_accessibilityHitTest_) {
            NSPoint point = new NSPoint();
            OS.memmove(point, arg0, (long)NSPoint.sizeof);
            id retObject = swtAcc.accessibilityHitTest(point);
            return retObject == null ? 0L : retObject.id;
        }
        if (sel == OS.sel_accessibilityIsAttributeSettable_) {
            NSString attribute = new NSString(arg0);
            return swtAcc.accessibilityIsAttributeSettable(attribute) ? 1 : 0;
        }
        if (sel == OS.sel_accessibilityActionDescription_) {
            NSString action = new NSString(arg0);
            id retObject = swtAcc.accessibilityActionDescription(action);
            return retObject == null ? 0L : retObject.id;
        }
        if (sel == OS.sel_accessibilityPerformAction_) {
            NSString action = new NSString(arg0);
            swtAcc.accessibilityPerformAction(action);
        }
        return 0L;
    }

    static long accessibleProc(long id2, long sel, long arg0, long arg1) {
        SWTAccessibleDelegate swtAcc = SWTAccessibleDelegate.getAccessibleDelegate(id2);
        if (swtAcc == null) {
            return 0L;
        }
        if (sel == OS.sel_accessibilityAttributeValue_forParameter_) {
            NSString attribute = new NSString(arg0);
            id parameter = new id(arg1);
            id retObject = swtAcc.accessibilityAttributeValue_forParameter(attribute, parameter);
            return retObject == null ? 0L : retObject.id;
        }
        if (sel == OS.sel_accessibilitySetValue_forAttribute_) {
            id value = new id(arg0);
            NSString attribute = new NSString(arg1);
            swtAcc.accessibilitySetValue_forAttribute(value, attribute);
        }
        return 0L;
    }

    static SWTAccessibleDelegate getAccessibleDelegate(long id2) {
        if (id2 == 0L) {
            return null;
        }
        long[] jniRef = new long[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0L) {
            return null;
        }
        return (SWTAccessibleDelegate)OS.JNIGetObject(jniRef[0]);
    }

    public void internal_dispose_SWTAccessibleDelegate() {
        if (this.actionNames != null) {
            this.actionNames.release();
        }
        this.actionNames = null;
        if (this.attributeNames != null) {
            this.attributeNames.release();
        }
        this.attributeNames = null;
        if (this.parameterizedAttributeNames != null) {
            this.parameterizedAttributeNames.release();
        }
        this.parameterizedAttributeNames = null;
        if (this.delegateJniRef != 0L) {
            OS.DeleteGlobalRef(this.delegateJniRef);
        }
        this.delegateJniRef = 0L;
        OS.object_setInstanceVariable(this.id, SWT_OBJECT, 0L);
    }
}

