/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.processes.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.processes.ui.ProcessesPlugin;
import org.eclipse.rse.internal.processes.ui.SystemProcessesResources;
import org.eclipse.rse.internal.processes.ui.dialogs.SystemKillDialog;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SystemKillProcessAction
extends SystemBaseDialogAction
implements IRunnableWithProgress {
    protected Exception runException = null;
    protected Object[] processesDeathRow;
    protected boolean killedOk = true;
    protected String signalType = null;

    public SystemKillProcessAction(Shell shell) {
        super(SystemProcessesResources.ACTION_KILLPROCESS_LABEL, SystemProcessesResources.ACTION_KILLPROCESS_TOOLTIP, ProcessesPlugin.getDefault().getImageDescriptorFromPath("/icons/full/elcl16/killprocessj.gif"), shell);
        this.allowOnMultipleSelection(true);
        this.setProcessAllSelections(true);
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.processes.ui.actn0001");
        this.setDialogHelp("org.eclipse.rse.processes.ui.dkrp0000");
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            if (selectedObject instanceof IRemoteProcess) continue;
            enable = false;
        }
        return enable;
    }

    protected Object getDialogValue(Dialog dlg) {
        SystemKillDialog killDlg = (SystemKillDialog)dlg;
        if (!killDlg.wasCancelled()) {
            this.signalType = killDlg.getSignal();
        }
        if (this.signalType.equals(SystemProcessesResources.RESID_KILL_SIGNAL_TYPE_DEFAULT)) {
            this.signalType = "default";
        }
        if (this.signalType != null) {
            IRunnableContext runnableContext = this.getRunnableContext();
            try {
                runnableContext.run(false, false, (IRunnableWithProgress)this);
            }
            catch (InvocationTargetException exc) {
                this.showOperationMessage((Exception)exc.getTargetException(), this.getShell());
            }
            catch (Exception exc) {
                this.showOperationMessage(exc, this.getShell());
            }
        }
        return null;
    }

    protected Dialog createDialog(Shell shell) {
        SystemKillDialog dlg = new SystemKillDialog(shell);
        return dlg;
    }

    protected IRunnableContext getRunnableContext() {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistryUI().getRunnableContext();
        if (irc == null) {
            irc = new ProgressMonitorDialog(this.getShell());
        }
        return irc;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SystemMessage msg = this.getKillingMessage();
        this.runException = null;
        this.populateSelectedObjects();
        try {
            int steps = this.processesDeathRow.length;
            monitor.beginTask(msg.getLevelOneText(), steps);
            this.killedOk = true;
            IRemoteProcess currentProcess = null;
            int idx = 0;
            while (this.killedOk && idx < steps) {
                currentProcess = (IRemoteProcess)this.processesDeathRow[idx];
                if (this.signalType.equals(SystemProcessesResources.RESID_KILL_SIGNAL_TYPE_DEFAULT)) {
                    this.signalType = "default";
                }
                monitor.subTask(this.getKillingMessage(this.signalType, currentProcess.getName()).getLevelOneText());
                this.killedOk = this.doKill(currentProcess, this.signalType, monitor);
                monitor.worked(1);
                ++idx;
            }
            monitor.done();
        }
        catch (InterruptedException exc) {
            monitor.done();
            this.runException = exc;
            throw (InterruptedException)this.runException;
        }
        catch (Exception exc) {
            monitor.done();
            this.runException = new InvocationTargetException(exc);
            throw (InvocationTargetException)this.runException;
        }
        this.killComplete();
    }

    protected boolean doKill(IRemoteProcess process, String signal, IProgressMonitor monitor) throws Exception {
        boolean ok = false;
        IRemoteProcessSubSystem ss = process.getParentRemoteProcessSubSystem();
        ok = ss.kill(process, signal);
        if (!ok) {
            SystemMessage msg = ProcessesPlugin.getPluginMessage("RSEPG1300");
            msg.makeSubstitution((Object)process.getName());
            throw new SystemMessageException(msg);
        }
        return ok;
    }

    public void killComplete() {
        if (this.processesDeathRow.length == 0) {
            return;
        }
        IRemoteProcessSubSystem processSS = ((IRemoteProcess)this.processesDeathRow[0]).getParentRemoteProcessSubSystem();
        List results = this.getAffectedFilters(this.processesDeathRow, (ISubSystem)processSS);
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        int i = 0;
        while (i < results.size()) {
            ISystemFilterReference ref = (ISystemFilterReference)results.get(i);
            ref.markStale(true);
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)ref, 95, (Object)ref));
            ++i;
        }
    }

    protected List getAffectedFilters(Object[] processesDeathRow, ISubSystem subSystem) {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < processesDeathRow.length) {
            List refs = registry.findFilterReferencesFor(processesDeathRow[i], subSystem);
            result.addAll(refs);
            ++i;
        }
        return result;
    }

    protected void populateSelectedObjects() {
        IStructuredSelection selection = this.getSelection();
        Iterator e = selection.iterator();
        Vector v = new Vector();
        while (e.hasNext()) {
            v.add(e.next());
        }
        this.processesDeathRow = v.toArray();
    }

    protected SystemMessage getKillingMessage() {
        return ProcessesPlugin.getPluginMessage("RSEPG1003");
    }

    protected SystemMessage getKillingMessage(String signal, String processName) {
        SystemMessage msg = null;
        msg = ProcessesPlugin.getPluginMessage("RSEPG1004");
        msg.makeSubstitution((Object)signal, (Object)processName);
        return msg;
    }

    protected void showOperationMessage(Exception exc, Shell shell) {
        if (exc instanceof InterruptedException) {
            this.showOperationCancelledMessage(shell);
        } else if (exc instanceof InvocationTargetException) {
            this.showOperationErrorMessage(shell, ((InvocationTargetException)exc).getTargetException());
        } else {
            this.showOperationErrorMessage(shell, exc);
        }
    }

    protected void showOperationErrorMessage(Shell shell, Throwable exc) {
        if (exc instanceof SystemMessageException) {
            this.showOperationErrorMessage(shell, (SystemMessageException)exc);
        } else {
            String msg = exc.getMessage();
            if (msg == null || exc instanceof ClassCastException) {
                msg = exc.getClass().getName();
            }
            SimpleSystemMessage smsg = new SimpleSystemMessage("org.eclipse.rse.processes.ui", "RSEG1066", 4, NLS.bind((String)CommonMessages.MSG_OPERATION_FAILED, (Object)msg));
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, (SystemMessage)smsg);
            msgDlg.setException(exc);
            msgDlg.open();
        }
    }

    protected void showOperationErrorMessage(Shell shell, SystemMessageException exc) {
        SystemMessage msg = exc.getSystemMessage();
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.open();
    }

    protected void showOperationCancelledMessage(Shell shell) {
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.processes.ui", "RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED);
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, (SystemMessage)msg);
        msgDlg.open();
    }
}

