/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleLoader;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.internal.container.AtomicLazyInitializer;
import org.eclipse.osgi.internal.container.InternalUtils;
import org.eclipse.osgi.internal.container.NamespaceList;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;

public final class ModuleWiring
implements BundleWiring {
    private static final RuntimePermission GET_CLASSLOADER_PERM = new RuntimePermission("getClassLoader");
    private static final String DYNAMICALLY_ADDED_IMPORT_DIRECTIVE = "x.dynamically.added";
    private final ModuleRevision revision;
    private volatile NamespaceList<ModuleCapability> capabilities;
    private volatile NamespaceList<ModuleRequirement> requirements;
    private final Collection<String> substitutedPkgNames;
    private final AtomicLazyInitializer<ModuleLoader> loader = new AtomicLazyInitializer();
    private final LoaderInitializer loaderInitializer = new LoaderInitializer();
    private volatile NamespaceList<ModuleWire> providedWires;
    private volatile NamespaceList<ModuleWire> requiredWires;
    volatile boolean isValid = true;
    private final AtomicReference<Set<String>> dynamicMissRef = new AtomicReference();

    ModuleWiring(ModuleRevision revision, NamespaceList<ModuleCapability> capabilities, NamespaceList<ModuleRequirement> requirements, NamespaceList<ModuleWire> providedWires, NamespaceList<ModuleWire> requiredWires, Collection<String> substitutedPkgNames) {
        this.revision = revision;
        this.capabilities = capabilities;
        this.requirements = requirements;
        this.providedWires = providedWires;
        this.requiredWires = requiredWires;
        this.substitutedPkgNames = substitutedPkgNames.isEmpty() ? Collections.emptyList() : substitutedPkgNames;
    }

    @Override
    public Bundle getBundle() {
        return this.revision.getBundle();
    }

    @Override
    public boolean isCurrent() {
        return this.isValid && this.revision.isCurrent();
    }

    @Override
    public boolean isInUse() {
        return this.isCurrent() || !this.providedWires.isEmpty() || this.isFragmentInUse();
    }

    private boolean isFragmentInUse() {
        if ((1 & this.revision.getTypes()) != 0) {
            List<ModuleWire> hostWires = this.getRequiredModuleWires("osgi.wiring.host");
            return hostWires == null ? false : !hostWires.isEmpty();
        }
        return false;
    }

    public List<ModuleCapability> getModuleCapabilities(String namespace) {
        if (!this.isValid) {
            return null;
        }
        return this.capabilities.getList(namespace);
    }

    public List<ModuleRequirement> getModuleRequirements(String namespace) {
        if (!this.isValid) {
            return null;
        }
        return this.requirements.getList(namespace);
    }

    List<ModuleRequirement> getPersistentRequirements() {
        if (!this.isValid) {
            return null;
        }
        ArrayList<ModuleRequirement> persistentRequriements = new ArrayList<ModuleRequirement>(this.requirements.getList(null));
        Iterator iRequirements = persistentRequriements.iterator();
        while (iRequirements.hasNext()) {
            ModuleRequirement requirement = (ModuleRequirement)iRequirements.next();
            if (!"osgi.wiring.package".equals(requirement.getNamespace()) || !"true".equals(requirement.getDirectives().get(DYNAMICALLY_ADDED_IMPORT_DIRECTIVE))) continue;
            iRequirements.remove();
        }
        return persistentRequriements;
    }

    @Override
    public List<BundleCapability> getCapabilities(String namespace) {
        return InternalUtils.asCopy(this.getModuleCapabilities(namespace));
    }

    @Override
    public List<BundleRequirement> getRequirements(String namespace) {
        return InternalUtils.asCopy(this.getModuleRequirements(namespace));
    }

    public List<ModuleWire> getProvidedModuleWires(String namespace) {
        return this.getWires(namespace, this.providedWires);
    }

    List<ModuleWire> getPersistentProvidedWires() {
        return this.getPersistentWires(this.providedWires);
    }

    public List<ModuleWire> getRequiredModuleWires(String namespace) {
        return this.getWires(namespace, this.requiredWires);
    }

    List<ModuleWire> getPersistentRequiredWires() {
        return this.getPersistentWires(this.requiredWires);
    }

    private List<ModuleWire> getPersistentWires(NamespaceList<ModuleWire> allWires) {
        if (!this.isValid) {
            return null;
        }
        ArrayList<ModuleWire> persistentWires = new ArrayList<ModuleWire>(allWires.getList(null));
        Iterator iWires = persistentWires.iterator();
        while (iWires.hasNext()) {
            ModuleWire wire = (ModuleWire)iWires.next();
            if (!"osgi.wiring.package".equals(wire.getRequirement().getNamespace()) || !"true".equals(wire.getRequirement().getDirectives().get(DYNAMICALLY_ADDED_IMPORT_DIRECTIVE))) continue;
            iWires.remove();
        }
        return persistentWires;
    }

    @Override
    public List<BundleWire> getProvidedWires(String namespace) {
        return InternalUtils.asCopy(this.getWires(namespace, this.providedWires));
    }

    @Override
    public List<BundleWire> getRequiredWires(String namespace) {
        return InternalUtils.asCopy(this.getWires(namespace, this.requiredWires));
    }

    private List<ModuleWire> getWires(String namespace, NamespaceList<ModuleWire> wires) {
        if (!this.isValid) {
            return null;
        }
        return wires.getList(namespace);
    }

    @Override
    public ModuleRevision getRevision() {
        return this.revision;
    }

    @Override
    public ClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASSLOADER_PERM);
        }
        if (!this.isValid) {
            return null;
        }
        ModuleLoader current = this.getModuleLoader();
        if (current == null) {
            return null;
        }
        return current.getClassLoader();
    }

    public ModuleLoader getModuleLoader() {
        return this.loader.getInitialized(this.loaderInitializer);
    }

    void loadFragments(Collection<ModuleRevision> fragments) {
        ModuleLoader current = this.loader.get();
        if (current != null) {
            current.loadFragments(fragments);
        }
    }

    @Override
    public List<URL> findEntries(String path, String filePattern, int options) {
        if (!this.hasResourcePermission()) {
            return Collections.emptyList();
        }
        if (!this.isValid) {
            return null;
        }
        ModuleLoader current = this.getModuleLoader();
        if (current == null) {
            return null;
        }
        return current.findEntries(path, filePattern, options);
    }

    @Override
    public Collection<String> listResources(String path, String filePattern, int options) {
        if (!this.hasResourcePermission()) {
            return Collections.emptyList();
        }
        if (!this.isValid) {
            return null;
        }
        ModuleLoader current = this.getModuleLoader();
        if (current == null) {
            return null;
        }
        return current.listResources(path, filePattern, options);
    }

    @Override
    public List<Capability> getResourceCapabilities(String namespace) {
        return InternalUtils.asCopy(this.getModuleCapabilities(namespace));
    }

    @Override
    public List<Requirement> getResourceRequirements(String namespace) {
        return InternalUtils.asCopy(this.getModuleRequirements(namespace));
    }

    @Override
    public List<Wire> getProvidedResourceWires(String namespace) {
        return InternalUtils.asCopy(this.getWires(namespace, this.providedWires));
    }

    @Override
    public List<Wire> getRequiredResourceWires(String namespace) {
        return InternalUtils.asCopy(this.getWires(namespace, this.requiredWires));
    }

    @Override
    public ModuleRevision getResource() {
        return this.revision;
    }

    void setProvidedWires(NamespaceList<ModuleWire> providedWires) {
        this.providedWires = providedWires;
    }

    void setRequiredWires(NamespaceList<ModuleWire> requiredWires) {
        this.requiredWires = requiredWires;
    }

    void setCapabilities(NamespaceList<ModuleCapability> capabilities) {
        this.capabilities = capabilities;
    }

    void setRequirements(NamespaceList<ModuleRequirement> requirements) {
        this.requirements = requirements;
    }

    void unload() {
        this.invalidate0(true);
    }

    void invalidate() {
        this.invalidate0(false);
    }

    private void invalidate0(boolean releaseLoader) {
        this.isValid = false;
        ModuleLoader current = releaseLoader ? this.loader.getAndClear() : this.loader.get();
        this.revision.getRevisions().getContainer().getAdaptor().invalidateWiring(this, current);
    }

    void validate() {
        this.isValid = true;
    }

    boolean isSubtituted(ModuleCapability capability) {
        if (!"osgi.wiring.package".equals(capability.getNamespace())) {
            return false;
        }
        return this.substitutedPkgNames.contains(capability.getAttributes().get("osgi.wiring.package"));
    }

    public boolean isSubstitutedPackage(String packageName) {
        return this.substitutedPkgNames.contains(packageName);
    }

    public Collection<String> getSubstitutedNames() {
        return Collections.unmodifiableCollection(this.substitutedPkgNames);
    }

    private boolean hasResourcePermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this.getBundle(), "resource"));
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    public void addDynamicImports(ModuleRevisionBuilder builder) {
        NamespaceList.Builder<ModuleRevisionBuilder.GenericInfo> newImports = builder.getRequirementsBuilder();
        NamespaceList.Builder<ModuleRequirement> newRequirements = newImports.transformIntoCopy(info -> {
            if (!"osgi.wiring.package".equals(info.getNamespace())) {
                throw new IllegalArgumentException("Invalid namespace for package imports: " + info.getNamespace());
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>(info.getAttributes());
            HashMap<String, String> directives = new HashMap<String, String>(info.getDirectives());
            directives.put(DYNAMICALLY_ADDED_IMPORT_DIRECTIVE, "true");
            directives.put("resolution", "dynamic");
            return new ModuleRequirement(info.getNamespace(), directives, attributes, this.revision);
        }, NamespaceList.REQUIREMENT);
        ModuleDatabase moduleDatabase = this.revision.getRevisions().getContainer().moduleDatabase;
        moduleDatabase.writeLockOperation(true, () -> {
            NamespaceList.Builder<ModuleRequirement> requirmentsBuilder = this.requirements.createBuilder();
            requirmentsBuilder.addAll(newRequirements);
            this.requirements = requirmentsBuilder.build();
            this.dynamicMissRef.updateAndGet(s -> {
                if (s != null) {
                    s.clear();
                }
                return s;
            });
        });
    }

    void addDynamicPackageMiss(String packageName) {
        Set<String> misses = this.dynamicMissRef.get();
        if (misses == null) {
            this.dynamicMissRef.compareAndSet(null, Collections.synchronizedSet(new HashSet()));
            misses = this.dynamicMissRef.get();
        }
        misses.add(packageName);
    }

    boolean isDynamicPackageMiss(String packageName) {
        Set<String> misses = this.dynamicMissRef.get();
        return misses != null && misses.contains(packageName);
    }

    void removeDynamicPackageMisses(Collection<String> packageNames) {
        Set<String> misses = this.dynamicMissRef.get();
        if (misses != null) {
            misses.removeAll(packageNames);
        }
    }

    public String toString() {
        return this.revision.toString();
    }

    List<Wire> getSubstitutionWires() {
        if (this.substitutedPkgNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Wire> substitutionWires = new ArrayList<Wire>(this.substitutedPkgNames.size());
        List<ModuleWire> current = this.requiredWires.getList("osgi.wiring.package");
        for (ModuleWire wire : current) {
            ModuleCapability cap = wire.getCapability();
            if (!this.substitutedPkgNames.contains(cap.getAttributes().get("osgi.wiring.package"))) continue;
            substitutionWires.add(wire);
        }
        return substitutionWires;
    }

    NamespaceList<ModuleCapability> getCapabilities() {
        return this.capabilities;
    }

    NamespaceList<ModuleWire> getProvidedWires() {
        return this.providedWires;
    }

    NamespaceList<ModuleRequirement> getRequirements() {
        return this.requirements;
    }

    NamespaceList<ModuleWire> getRequiredWires() {
        return this.requiredWires;
    }

    class LoaderInitializer
    implements Callable<ModuleLoader> {
        LoaderInitializer() {
        }

        @Override
        public ModuleLoader call() throws Exception {
            if (!ModuleWiring.this.isValid) {
                return null;
            }
            return ModuleWiring.this.getRevision().getRevisions().getContainer().adaptor.createModuleLoader(ModuleWiring.this);
        }
    }
}

