/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.codeactions.CodeActionMarkerResolution;
import org.eclipse.lsp4e.operations.codeactions.CommandMarkerResolution;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.internal.progress.ProgressInfoItem;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class LSPCodeActionMarkerResolution
implements IMarkerResolutionGenerator2 {
    private static final String LSP_REMEDIATION = "lspCodeActions";
    private static final IMarkerResolution2 COMPUTING = new IMarkerResolution2(){

        public void run(IMarker marker) {
        }

        public String getLabel() {
            return Messages.computing;
        }

        public Image getImage() {
            return JFaceResources.getImage((String)(String.valueOf(ProgressInfoItem.class.getPackage().getName()) + ".PROGRESS_DEFAULT"));
        }

        public String getDescription() {
            return Messages.computing;
        }
    };

    public IMarkerResolution[] getResolutions(IMarker marker) {
        Object att = null;
        try {
            att = marker.getAttribute(LSP_REMEDIATION);
            if (att == null) {
                this.checkMarkerResoultion(marker);
                att = marker.getAttribute(LSP_REMEDIATION);
            }
        }
        catch (IOException | ExecutionException | CoreException e) {
            LanguageServerPlugin.logError(e);
            return new IMarkerResolution[0];
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return new IMarkerResolution[0];
        }
        if (att == COMPUTING) {
            return new IMarkerResolution[]{COMPUTING};
        }
        if (att == null) {
            return new IMarkerResolution[0];
        }
        List commands = (List)att;
        ArrayList<WorkbenchMarkerResolution> res = new ArrayList<WorkbenchMarkerResolution>(commands.size());
        for (Either command : commands) {
            if (command == null) continue;
            if (command.isLeft()) {
                res.add(new CommandMarkerResolution((Command)command.getLeft()));
                continue;
            }
            res.add(new CodeActionMarkerResolution((CodeAction)command.getRight()));
        }
        return res.toArray(new IMarkerResolution[res.size()]);
    }

    private void checkMarkerResoultion(IMarker marker) throws IOException, CoreException, InterruptedException, ExecutionException {
        IResource res = marker.getResource();
        if (res != null && res.getType() == 1) {
            IFile file = (IFile)res;
            Object[] attributes = marker.getAttributes(new String[]{"languageServerId", "lspDiagnostic"});
            String languageServerId = (String)attributes[0];
            Diagnostic diagnostic = (Diagnostic)attributes[1];
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            for (CompletableFuture<LanguageServer> lsf : this.getLanguageServerFutures(file, languageServerId)) {
                marker.setAttribute(LSP_REMEDIATION, (Object)COMPUTING);
                CodeActionContext context = new CodeActionContext(Collections.singletonList(diagnostic));
                CodeActionParams params = new CodeActionParams();
                params.setContext(context);
                params.setTextDocument(new TextDocumentIdentifier(LSPEclipseUtils.toUri(res).toString()));
                params.setRange(diagnostic.getRange());
                CompletionStage codeAction = lsf.thenComposeAsync(ls -> ls.getTextDocumentService().codeAction(params));
                futures.add(codeAction);
                ((CompletableFuture)codeAction).thenAcceptAsync(actions -> {
                    try {
                        marker.setAttribute(LSP_REMEDIATION, actions);
                    }
                    catch (CoreException e) {
                        LanguageServerPlugin.logError(e);
                    }
                });
            }
            try {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).get(300L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning("Could get code actions due to timeout after 300 miliseconds in `textDocument/codeAction`", e);
            }
        }
    }

    private List<CompletableFuture<LanguageServer>> getLanguageServerFutures(@NonNull IFile file, @Nullable String languageServerId) throws IOException {
        CompletableFuture<LanguageServer> serverFuture;
        LanguageServersRegistry.LanguageServerDefinition definition;
        ArrayList<CompletableFuture<LanguageServer>> languageServerFutures = new ArrayList<CompletableFuture<LanguageServer>>();
        if (languageServerId != null && (definition = LanguageServersRegistry.getInstance().getDefinition(languageServerId)) != null && (serverFuture = LanguageServiceAccessor.getInitializedLanguageServer(file, definition, serverCapabilities -> serverCapabilities == null || LSPCodeActionMarkerResolution.providesCodeActions(serverCapabilities))) != null) {
            languageServerFutures.add(serverFuture);
        }
        if (languageServerFutures.isEmpty()) {
            languageServerFutures.addAll(LanguageServiceAccessor.getInitializedLanguageServers(file, capabilities -> {
                Either codeActionProvider = capabilities.getCodeActionProvider();
                if (codeActionProvider == null) {
                    return false;
                }
                if (codeActionProvider.isLeft()) {
                    return Boolean.TRUE.equals(codeActionProvider.getLeft());
                }
                return codeActionProvider.isRight();
            }));
        }
        return languageServerFutures;
    }

    static boolean providesCodeActions(@NonNull ServerCapabilities serverCapabilities) {
        Either codeActionProvider = serverCapabilities.getCodeActionProvider();
        if (codeActionProvider == null) {
            return false;
        }
        if (codeActionProvider.isLeft()) {
            return codeActionProvider.getLeft() != null && (Boolean)codeActionProvider.getLeft() != false;
        }
        if (codeActionProvider.isRight()) {
            return codeActionProvider.getRight() != null;
        }
        return false;
    }

    public boolean hasResolutions(IMarker marker) {
        try {
            Object remediation = marker.getAttribute(LSP_REMEDIATION);
            if (remediation == null) {
                this.checkMarkerResoultion(marker);
                remediation = marker.getAttribute(LSP_REMEDIATION);
            }
            return remediation == COMPUTING || remediation instanceof Collection && !((Collection)remediation).isEmpty();
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            return false;
        }
    }
}

