/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.decorators.DecorationResult;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class StagingViewLabelProvider
extends ColumnLabelProvider {
    private StagingView stagingView;
    private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
    private final Image FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final GitLightweightDecorator.DecorationHelper decorationHelper;
    private final GitLightweightDecorator.ChangeTrackingColorsAndFonts colorsAndFonts = new GitLightweightDecorator.ChangeTrackingColorsAndFonts();
    private boolean fileNameMode = false;

    public StagingViewLabelProvider(StagingView stagingView) {
        this.decorationHelper = new GitLightweightDecorator.DecorationHelper(Activator.getDefault().getPreferenceStore(), this.colorsAndFonts);
        this.colorsAndFonts.addListener(this::postLabelEvent);
        this.stagingView = stagingView;
    }

    public StagingViewLabelProvider setFileNameMode(boolean enable) {
        this.fileNameMode = enable;
        return this;
    }

    public void dispose() {
        this.colorsAndFonts.dispose();
        this.resourceManager.dispose();
        super.dispose();
    }

    private void postLabelEvent() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this)));
    }

    private Image getEditorImage(StagingEntry diff) {
        if (diff.isSubmodule()) {
            return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.REPOSITORY);
        }
        Image image = diff.getPath() != null ? (Image)this.resourceManager.get((DeviceResourceDescriptor)UIUtils.getEditorImage(diff.getPath())) : (Image)this.resourceManager.get((DeviceResourceDescriptor)UIUtils.DEFAULT_FILE_IMG);
        if (diff.isSymlink()) {
            if (diff.getLocation().toFile().isDirectory()) {
                image = this.FOLDER;
            }
            image = this.addSymlinkDecorationToImage(image);
        }
        return image;
    }

    private Image getDecoratedImage(Image base, ImageDescriptor decorator) {
        DecorationOverlayIcon decorated = new DecorationOverlayIcon(base, decorator, 3);
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)decorated);
    }

    private Image addSymlinkDecorationToImage(Image base) {
        DecorationOverlayIcon decorated = new DecorationOverlayIcon(base, UIIcons.OVR_SYMLINK, 1);
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)decorated);
    }

    public Image getImage(Object element) {
        if (element instanceof StagingFolderEntry) {
            StagingFolderEntry c = (StagingFolderEntry)element;
            if (c.getContainer() == null) {
                return this.FOLDER;
            }
            return this.workbenchLabelProvider.getImage((Object)((StagingFolderEntry)element).getContainer());
        }
        StagingEntry c = (StagingEntry)element;
        DecorationResult decoration = new DecorationResult();
        this.decorationHelper.decorate(decoration, c);
        return this.getDecoratedImage(this.getEditorImage(c), decoration.getOverlay());
    }

    public String getText(Object element) {
        if (element instanceof StagingFolderEntry) {
            StagingFolderEntry stagingFolderEntry = (StagingFolderEntry)element;
            return stagingFolderEntry.getLabel();
        }
        StagingEntry stagingEntry = this.getStagingEntry(element);
        if (stagingEntry == null) {
            return "";
        }
        DecorationResult decoration = new DecorationResult();
        this.decorationHelper.decorate(decoration, stagingEntry);
        String prefix = decoration.getPrefix();
        String suffix = decoration.getSuffix();
        StringBuilder label = new StringBuilder();
        if (prefix != null) {
            label.append(prefix);
        }
        if (this.stagingView.getPresentation() == StagingView.Presentation.LIST) {
            IPath parsed;
            if (this.fileNameMode && (parsed = Path.fromOSString((String)stagingEntry.getPath())).segmentCount() > 1) {
                label.append(parsed.lastSegment());
                if (suffix != null) {
                    label.append(suffix);
                }
                label.append(" - ").append(parsed.removeLastSegments(1).toString());
                return label.toString();
            }
            label.append(stagingEntry.getPath());
        } else {
            label.append(stagingEntry.getName());
        }
        if (suffix != null) {
            label.append(suffix);
        }
        return label.toString();
    }

    @Nullable
    private StagingEntry getStagingEntry(Object element) {
        TreeItem item;
        StagingEntry entry = null;
        if (element instanceof StagingEntry) {
            entry = (StagingEntry)element;
        }
        if (element instanceof TreeItem && (item = (TreeItem)element).getData() instanceof StagingEntry) {
            entry = (StagingEntry)item.getData();
        }
        return entry;
    }
}

