/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.op.FeatureRebaseOperation;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.JobFamilies;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.AbstractGitFlowHandler;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class FeatureRebaseHandler
extends AbstractGitFlowHandler {
    private static final String INTERACTIVE_REBASE_VIEW_ID = "org.eclipse.egit.ui.InteractiveRebaseView";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        GitFlowRepository gfRepo = GitFlowHandlerUtil.getRepository(event);
        FeatureRebaseOperation rebaseOperation = new FeatureRebaseOperation(gfRepo);
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)rebaseOperation, (String)UIText.FeatureRebaseHandler_rebasingFeature, (Object)JobFamilies.GITFLOW_FAMILY);
        IJobManager jobMan = Job.getJobManager();
        try {
            jobMan.join(JobFamilies.GITFLOW_FAMILY, null);
        }
        catch (InterruptedException | OperationCanceledException e) {
            return Activator.error(e.getMessage(), e);
        }
        RebaseResult operationResult = rebaseOperation.getOperationResult();
        RebaseResult.Status status = operationResult.getStatus();
        if (status.isSuccessful()) {
            return null;
        }
        if (RebaseResult.Status.STOPPED.equals((Object)status)) {
            try {
                this.showInteractiveRebaseView(event);
            }
            catch (PartInitException e) {
                return Activator.error(e.getMessage(), e);
            }
        }
        this.openWarning(operationResult);
        return null;
    }

    private void showInteractiveRebaseView(ExecutionEvent event) throws PartInitException, ExecutionException {
        HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage().showView(INTERACTIVE_REBASE_VIEW_ID);
    }

    private void openWarning(RebaseResult operationResult) {
        RebaseResult.Status status = operationResult.getStatus();
        String pluginId = Activator.getPluginId();
        MultiStatus info = new MultiStatus(pluginId, 1, UIText.FeatureRebaseHandler_problemsOccurredDuringRebase, null);
        info.add((IStatus)new Status(2, pluginId, NLS.bind((String)UIText.FeatureRebaseHandler_statusWas, (Object)status.name())));
        if (operationResult.getConflicts() != null && !operationResult.getConflicts().isEmpty()) {
            MultiStatus warning = this.createRebaseConflictWarning(operationResult);
            info.addAll((IStatus)warning);
        }
        ErrorDialog.openError(null, (String)UIText.FeatureRebaseHandler_problemsOccurred, null, (IStatus)info);
    }
}

