/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.net;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.Policy;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.StringUtil;
import org.eclipse.core.internal.net.proxy.win32.winhttp.StaticProxyConfig;
import org.eclipse.core.net.proxy.IProxyData;

public class ProxyProvider
extends AbstractProxyProvider {
    private static final String LIBRARY_NAME = "winhttp";
    private static final String USER_AGENT = "WinHttpProxyProvider";
    private static final ProxyData[] EMPTY_PROXIES = new ProxyData[0];
    private static WinHttp fWinHttp;
    private static boolean isWinHttpLoaded;
    private Pointer hHttpSession;
    private boolean isWinHttpInitialized = false;
    private StaticProxyConfig fStaticProxyConfig;
    private String fProxiesString;
    private String fProxyBypassString;

    static {
        isWinHttpLoaded = false;
        try {
            fWinHttp = (WinHttp)Native.load((String)LIBRARY_NAME, WinHttp.class, (Map)W32APIOptions.UNICODE_OPTIONS);
            fWinHttp = (WinHttp)Native.synchronizedLibrary((Library)fWinHttp);
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug((String)("Loaded library " + System.mapLibraryName(LIBRARY_NAME)));
            }
            isWinHttpLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug((String)("Could not load library " + System.mapLibraryName(LIBRARY_NAME)));
            }
            Activator.logError((String)"Problem during initializing system proxy configuration.", (Throwable)e);
        }
    }

    public ProxyProvider() {
        if (isWinHttpLoaded) {
            this.initialize();
        }
    }

    public IProxyData[] select(URI uri) {
        IProxyData[] proxies = this.getSystemProxyInfo(uri);
        if (Policy.DEBUG) {
            Policy.debug((String)("WindowsProxyProvider#select result for [" + uri + "]"));
            IProxyData[] iProxyDataArray = proxies;
            int n = proxies.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData proxy = iProxyDataArray[n2];
                System.out.println("\t" + proxy);
                ++n2;
            }
        }
        return proxies;
    }

    /*
     * Exception decompiling
     */
    protected IProxyData[] getSystemProxyInfo(URI uri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IProxyData[] getProxyData() {
        WinHttp.WinHttpCurrentUserIEProxyConfig proxyConfig = this.getProxyConfig();
        if (proxyConfig == null) {
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug((String)"Error getting proxy configuration");
            }
            return EMPTY_PROXIES;
        }
        try {
            if (this.isWinHttpInitialized && (proxyConfig.fAutoDetect || proxyConfig.lpszAutoConfigUrl != null)) {
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug((String)"Dynamic proxy configuration");
                }
                ProxyData data = new ProxyData("HTTP", "", -1, false, "WINDOWS_IE");
                data.setDynamic(true);
                IProxyData[] iProxyDataArray = new IProxyData[]{data};
                return iProxyDataArray;
            }
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug((String)"Static proxy configuration");
            }
            if (proxyConfig.lpszProxy != null) {
                StaticProxyConfig staticProxyConfig = this.getStaticConfig(proxyConfig.getProxy(), proxyConfig.getProxyBypass());
                IProxyData[] iProxyDataArray = staticProxyConfig.getProxyData();
                return iProxyDataArray;
            }
        }
        finally {
            proxyConfig.free();
        }
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug((String)"No proxy configuration");
        }
        return EMPTY_PROXIES;
    }

    protected String[] getNonProxiedHosts() {
        WinHttp.WinHttpCurrentUserIEProxyConfig proxyConfig = this.getProxyConfig();
        if (proxyConfig == null) {
            return null;
        }
        try {
            if (this.isWinHttpInitialized && (proxyConfig.fAutoDetect || proxyConfig.lpszAutoConfigUrl != null)) {
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug((String)"Dynamic proxy configuration");
                }
                return null;
            }
            if (proxyConfig.lpszProxy != null) {
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug((String)"Static proxy configuration");
                }
                StaticProxyConfig staticProxyConfig = this.getStaticConfig(proxyConfig.getProxy(), proxyConfig.getProxyBypass());
                String[] stringArray = staticProxyConfig.getNonProxiedHosts();
                return stringArray;
            }
        }
        finally {
            proxyConfig.free();
        }
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug((String)"No proxy configuration");
        }
        return null;
    }

    private void initialize() {
        try {
            this.hHttpSession = fWinHttp.WinHttpOpen(USER_AGENT, 1, WinHttp.NO_PROXY_NAME, WinHttp.NO_PROXY_BYPASS, 0);
            this.isWinHttpInitialized = true;
        }
        catch (LastErrorException e) {
            this.isWinHttpInitialized = false;
            Activator.logError((String)("Problem during initializing WinHTTP session:" + ProxyProvider.formatMessage(e.getErrorCode())), null);
        }
    }

    private WinHttp.WinHttpCurrentUserIEProxyConfig getProxyConfig() {
        if (isWinHttpLoaded) {
            WinHttp.WinHttpCurrentUserIEProxyConfig proxyConfig = new WinHttp.WinHttpCurrentUserIEProxyConfig();
            try {
                fWinHttp.WinHttpGetIEProxyConfigForCurrentUser(proxyConfig);
                return proxyConfig;
            }
            catch (LastErrorException e) {
                proxyConfig.free();
                Activator.logError((String)("Problem during loading proxy configuration: " + ProxyProvider.formatMessage(e.getErrorCode())), null);
            }
        }
        return null;
    }

    private StaticProxyConfig getStaticConfig(String proxyString, String proxyBypassString) {
        if (this.fStaticProxyConfig == null || !StringUtil.equals((CharSequence)this.fProxiesString, (CharSequence)proxyString) || !StringUtil.equals((CharSequence)this.fProxyBypassString, (CharSequence)proxyBypassString)) {
            this.fStaticProxyConfig = new StaticProxyConfig(proxyString, proxyBypassString);
            this.fProxiesString = proxyString;
            this.fProxyBypassString = proxyBypassString;
        }
        return this.fStaticProxyConfig;
    }

    private static boolean getProxyForUrl(Pointer hSession, String lpcwszUrl, WinHttp.WinHttpAutoProxyOptions pAutoProxyOptions, WinHttp.WinHttpProxyInfo pProxyInfo) throws LastErrorException {
        try {
            return fWinHttp.WinHttpGetProxyForUrl(hSession, lpcwszUrl, pAutoProxyOptions, pProxyInfo);
        }
        catch (LastErrorException e) {
            if (e.getErrorCode() == 12015) {
                pAutoProxyOptions.fAutoLogonIfChallenged = true;
                return fWinHttp.WinHttpGetProxyForUrl(hSession, lpcwszUrl, pAutoProxyOptions, pProxyInfo);
            }
            throw e;
        }
    }

    private static IProxyData[] toArray(List<IProxyData> proxies) {
        return proxies.toArray(new IProxyData[proxies.size()]);
    }

    private static String formatMessage(int code) {
        if (code >= 12000 && code <= 12186) {
            WinDef.HMODULE hmodule = Kernel32.INSTANCE.GetModuleHandle(System.mapLibraryName(LIBRARY_NAME));
            if (hmodule == null) {
                return "Error code " + code + "; No error message due to failure of \ufffdGetModuleHandle(" + System.mapLibraryName(LIBRARY_NAME) + ")\ufffd.";
            }
            PointerByReference msgBuf = new PointerByReference();
            int size = Kernel32.INSTANCE.FormatMessage(2816, hmodule.getPointer(), code, WinNT.LANG_USER_DEFAULT, msgBuf, 0, null);
            if (size == 0) {
                return "Error code " + code + "; No error message due to error " + Native.getLastError();
            }
            Pointer ptr = msgBuf.getValue();
            try {
                String str = ptr.getWideString(0L);
                String string = str.trim();
                return string;
            }
            finally {
                Kernel32Util.freeLocalMemory((Pointer)ptr);
            }
        }
        try {
            return Kernel32Util.formatMessage((int)code);
        }
        catch (LastErrorException e) {
            return "Error code " + code + "; No error message due to error " + e.getErrorCode();
        }
    }

    private static interface WinHttp
    extends StdCallLibrary {
        public static final int ERROR_BASE = 12000;
        public static final int ERROR_LOGIN_FAILURE = 12015;
        public static final int ERROR_LAST = 12186;
        public static final int ACCESS_TYPE_NO_PROXY = 1;
        public static final String NO_PROXY_NAME = null;
        public static final String NO_PROXY_BYPASS = null;
        public static final int AUTOPROXY_AUTO_DETECT = 1;
        public static final int AUTOPROXY_CONFIG_URL = 2;
        public static final int AUTO_DETECT_TYPE_DHCP = 1;
        public static final int AUTO_DETECT_TYPE_DNS_A = 2;

        public boolean WinHttpCloseHandle(Pointer var1) throws LastErrorException;

        public Pointer WinHttpOpen(String var1, int var2, String var3, String var4, int var5) throws LastErrorException;

        public boolean WinHttpGetIEProxyConfigForCurrentUser(WinHttpCurrentUserIEProxyConfig var1) throws LastErrorException;

        public boolean WinHttpGetProxyForUrl(Pointer var1, String var2, WinHttpAutoProxyOptions var3, WinHttpProxyInfo var4) throws LastErrorException;

        @Structure.FieldOrder(value={"dwFlags", "dwAutoDetectFlags", "lpszAutoConfigUrl", "lpvReserved", "dwReserved", "fAutoLogonIfChallenged"})
        public static class WinHttpAutoProxyOptions
        extends Structure {
            public int dwFlags;
            public int dwAutoDetectFlags;
            public String lpszAutoConfigUrl;
            public Pointer lpvReserved;
            public int dwReserved;
            public boolean fAutoLogonIfChallenged;
        }

        @Structure.FieldOrder(value={"fAutoDetect", "lpszAutoConfigUrl", "lpszProxy", "lpszProxyBypass"})
        public static class WinHttpCurrentUserIEProxyConfig
        extends Structure {
            public boolean fAutoDetect;
            public WTypes.LPWSTR lpszAutoConfigUrl;
            public WTypes.LPWSTR lpszProxy;
            public WTypes.LPWSTR lpszProxyBypass;

            public String getAutoConfigUrl() {
                return this.lpszAutoConfigUrl == null ? null : this.lpszAutoConfigUrl.getValue();
            }

            public String getProxy() {
                return this.lpszProxy == null ? null : this.lpszProxy.getValue();
            }

            public String getProxyBypass() {
                return this.lpszProxyBypass == null ? null : this.lpszProxyBypass.getValue();
            }

            public void free() {
                if (this.lpszAutoConfigUrl != null) {
                    Kernel32Util.freeGlobalMemory((Pointer)this.lpszAutoConfigUrl.getPointer());
                }
                if (this.lpszProxy != null) {
                    Kernel32Util.freeGlobalMemory((Pointer)this.lpszProxy.getPointer());
                }
                if (this.lpszProxyBypass != null) {
                    Kernel32Util.freeGlobalMemory((Pointer)this.lpszProxyBypass.getPointer());
                }
            }
        }

        @Structure.FieldOrder(value={"dwAccessType", "lpszProxy", "lpszProxyBypass"})
        public static class WinHttpProxyInfo
        extends Structure {
            public int dwAccessType;
            public WTypes.LPWSTR lpszProxy;
            public WTypes.LPWSTR lpszProxyBypass;

            public String getProxy() {
                return this.lpszProxy == null ? null : this.lpszProxy.getValue();
            }

            public String getProxyBypass() {
                return this.lpszProxyBypass == null ? null : this.lpszProxyBypass.getValue();
            }

            public void free() {
                if (this.lpszProxy != null) {
                    Kernel32Util.freeGlobalMemory((Pointer)this.lpszProxy.getPointer());
                }
                if (this.lpszProxyBypass != null) {
                    Kernel32Util.freeGlobalMemory((Pointer)this.lpszProxyBypass.getPointer());
                }
            }
        }
    }
}

