/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.importexport.breakpoints.EmbeddedBreakpointsViewer;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class BreakpointWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = DebugUIViewsMessages.BreakpointWorkingSetPage_0;
    private static final String PAGE_ID = "breakpointWorkingSetPage";
    private Text fWorkingSetName;
    private EmbeddedBreakpointsViewer fTViewer;
    private boolean fFirstCheck;
    private IWorkingSet fWorkingSet;

    public BreakpointWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, DebugPluginImages.getImageDescriptor("IMG_WIZBAN_DEBUG"));
        this.setDescription(DebugUIViewsMessages.BreakpointWorkingSetPage_1);
        this.fFirstCheck = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(DebugUIViewsMessages.BreakpointWorkingSetPage_2);
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(e -> this.validateInput());
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(DebugUIViewsMessages.BreakpointWorkingSetPage_3);
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        IViewPart viewpart = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.debug.ui.BreakpointView");
        Object selection = viewpart == null ? new StructuredSelection() : (IStructuredSelection)viewpart.getViewSite().getSelectionProvider().getSelection();
        this.fTViewer = new EmbeddedBreakpointsViewer(composite, DebugPlugin.getDefault().getBreakpointManager(), (IStructuredSelection)selection);
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = SWTFactory.createPushButton(buttonComposite, DebugUIViewsMessages.BreakpointWorkingSetPage_selectAll_label, null);
        selectAllButton.setToolTipText(DebugUIViewsMessages.BreakpointWorkingSetPage_selectAll_toolTip);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BreakpointsViewer viewer = BreakpointWorkingSetPage.this.fTViewer.getViewer();
                viewer.getTree().selectAll();
                viewer.setCheckedElements(viewer.getStructuredSelection().toArray());
                viewer.setGrayedElements(new Object[0]);
                viewer.getTree().deselectAll();
                BreakpointWorkingSetPage.this.validateInput();
            }
        });
        Button deselectAllButton = SWTFactory.createPushButton(buttonComposite, DebugUIViewsMessages.BreakpointWorkingSetPage_deselectAll_label, null);
        deselectAllButton.setToolTipText(DebugUIViewsMessages.BreakpointWorkingSetPage_deselectAll_toolTip);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BreakpointsViewer viewer = BreakpointWorkingSetPage.this.fTViewer.getViewer();
                viewer.setCheckedElements(new Object[0]);
                BreakpointWorkingSetPage.this.validateInput();
            }
        });
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.validateInput();
        Dialog.applyDialogFont((Control)composite);
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        Assert.isNotNull((Object)workingSet, (String)"Working set must not be null");
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.validateInput();
        }
    }

    public void finish() {
        String workingSetName = this.fWorkingSetName.getText();
        ArrayList<IBreakpoint> elements = new ArrayList<IBreakpoint>();
        for (Object adaptableElement : this.fTViewer.getCheckedElements()) {
            IBreakpoint breakpoint = (IBreakpoint)DebugPlugin.getAdapter(adaptableElement, IBreakpoint.class);
            if (breakpoint == null) continue;
            elements.add(breakpoint);
        }
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
        } else {
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private void validateInput() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = DebugUIViewsMessages.BreakpointWorkingSetPage_4;
        }
        if (newText.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            errorMessage = DebugUIViewsMessages.BreakpointWorkingSetPage_5;
        }
        this.fFirstCheck = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = iWorkingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                if (newText.equals(workingSet.getName())) {
                    errorMessage = DebugUIViewsMessages.BreakpointWorkingSetPage_6;
                }
                ++n2;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

