/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.internal.console.ConsoleFactoryExtension;
import org.eclipse.ui.internal.console.ConsoleManager;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;

public class OpenConsoleAction
extends Action
implements IMenuCreator {
    private ConsoleFactoryExtension[] fFactoryExtensions = this.getSortedFactories();
    private Menu fMenu;

    public OpenConsoleAction() {
        super(ConsoleMessages.OpenConsoleAction_0, 4);
        this.setToolTipText(ConsoleMessages.OpenConsoleAction_1);
        this.setImageDescriptor(ConsolePluginImages.getImageDescriptor("IMG_ELCL_NEW_CON"));
        this.setDisabledImageDescriptor(ConsolePluginImages.getImageDescriptor("IMG_DLCL_NEW_CON"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IConsoleHelpContextIds.CONSOLE_OPEN_CONSOLE_ACTION);
    }

    private ConsoleFactoryExtension[] getSortedFactories() {
        ConsoleFactoryExtension[] factoryExtensions = ((ConsoleManager)ConsolePlugin.getDefault().getConsoleManager()).getConsoleFactoryExtensions();
        Arrays.sort(factoryExtensions, (e1, e2) -> {
            if (e1.isNewConsoleExtenson()) {
                return -1;
            }
            if (e2.isNewConsoleExtenson()) {
                return 1;
            }
            String first = e1.getLabel();
            String second = e2.getLabel();
            return first.compareTo(second);
        });
        return factoryExtensions;
    }

    public void dispose() {
        this.fFactoryExtensions = null;
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        int accel = 1;
        ConsoleFactoryExtension[] consoleFactoryExtensionArray = this.fFactoryExtensions;
        int n = this.fFactoryExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleFactoryExtension extension = consoleFactoryExtensionArray[n2];
            if (!WorkbenchActivityHelper.filterItem((Object)extension) && extension.isEnabled()) {
                String label = extension.getLabel();
                ImageDescriptor image = extension.getImageDescriptor();
                this.addActionToMenu(this.fMenu, new ConsoleFactoryAction(label, image, extension), accel);
                ++accel;
                if (extension.isNewConsoleExtenson()) {
                    new Separator("new").fill(this.fMenu, -1);
                }
            }
            ++n2;
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuilder label = new StringBuilder();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private class ConsoleFactoryAction
    extends Action {
        private ConsoleFactoryExtension fConfig;
        private IConsoleFactory fFactory;

        public ConsoleFactoryAction(String label, ImageDescriptor image, ConsoleFactoryExtension extension) {
            this.setText(label);
            if (image != null) {
                this.setImageDescriptor(image);
            }
            this.fConfig = extension;
        }

        public void run() {
            try {
                if (this.fFactory == null) {
                    this.fFactory = this.fConfig.createFactory();
                }
                this.fFactory.openConsole();
            }
            catch (CoreException e) {
                ConsolePlugin.log(e);
            }
        }

        public void runWithEvent(Event event) {
            this.run();
        }
    }
}

