/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.filters.ISystemFilterStringReference;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.filters.SystemFilterPoolDialogInputs;
import org.eclipse.rse.ui.filters.SystemFilterPoolDialogInterface;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemFilterAbstractFilterPoolAction
extends SystemBaseDialogAction {
    protected SystemFilterPoolDialogInputs dlgInputs;
    protected String mgrNamePreselect;

    public SystemFilterAbstractFilterPoolAction(Shell parent, String title) {
        super(title, (ImageDescriptor)null, parent);
        this.allowOnMultipleSelection(false);
        this.init();
    }

    public SystemFilterAbstractFilterPoolAction(Shell parent, String title, String tooltip) {
        super(title, tooltip, (ImageDescriptor)null, parent);
        this.allowOnMultipleSelection(false);
        this.init();
    }

    public SystemFilterAbstractFilterPoolAction(Shell parent, ImageDescriptor image, String label, String tooltip) {
        super(label, tooltip, image, parent);
        this.allowOnMultipleSelection(false);
        this.init();
    }

    protected void init() {
        this.dlgInputs = new SystemFilterPoolDialogInputs();
    }

    public void setHelpContextId(String id) {
        this.setHelp(id);
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection);
        Object firstSelection = this.getFirstSelection();
        if (this.isEnabled() && firstSelection != null) {
            if (firstSelection instanceof SystemSimpleContentElement) {
                firstSelection = ((SystemSimpleContentElement)firstSelection).getData();
            }
            if (firstSelection instanceof ISystemFilterPoolManagerProvider) {
                this.setFilterPoolManagerProvider((ISystemFilterPoolManagerProvider)firstSelection);
            } else if (firstSelection instanceof ISystemFilterPoolManager) {
                this.setFilterPoolManagerProvider(((ISystemFilterPoolManager)firstSelection).getProvider());
            } else if (firstSelection instanceof ISystemFilterPool) {
                this.setFilterPoolManagerProvider(((ISystemFilterPool)firstSelection).getProvider());
            } else if (firstSelection instanceof ISystemFilter) {
                this.setFilterPoolManagerProvider(((ISystemFilter)firstSelection).getProvider());
            } else if (firstSelection instanceof ISystemFilterString) {
                this.setFilterPoolManagerProvider(((ISystemFilterString)firstSelection).getProvider());
            } else if (firstSelection instanceof ISystemFilterPoolReferenceManagerProvider) {
                this.setFilterPoolReferenceManager(((ISystemFilterPoolReferenceManagerProvider)firstSelection).getSystemFilterPoolReferenceManager());
            } else if (firstSelection instanceof ISystemFilterPoolReferenceManager) {
                this.setFilterPoolReferenceManager((ISystemFilterPoolReferenceManager)firstSelection);
            } else if (firstSelection instanceof ISystemFilterPoolReference) {
                this.setFilterPoolReferenceManager(((ISystemFilterPoolReference)firstSelection).getFilterPoolReferenceManager());
            } else if (firstSelection instanceof ISystemFilterReference) {
                this.setFilterPoolReferenceManager(((ISystemFilterReference)firstSelection).getFilterPoolReferenceManager());
            } else if (firstSelection instanceof ISystemFilterStringReference) {
                this.setFilterPoolReferenceManager(((ISystemFilterStringReference)firstSelection).getFilterPoolReferenceManager());
            }
        }
    }

    public void setFilterPoolManagerProvider(ISystemFilterPoolManagerProvider provider) {
        this.dlgInputs.poolManagerProvider = provider;
    }

    public ISystemFilterPoolManagerProvider getFilterPoolManagerProvider() {
        return this.dlgInputs.poolManagerProvider;
    }

    public void setFilterPoolManagers(ISystemFilterPoolManager[] managers) {
        this.dlgInputs.poolManagers = managers;
    }

    public ISystemFilterPoolManager[] getFilterPoolManagers() {
        ISystemFilterPoolReferenceManagerProvider sfprmp;
        ISystemFilterPoolReferenceManager refmgr;
        ISystemFilterPoolManager[] mgrs = null;
        ISystemFilterPoolManagerProvider provider = this.getFilterPoolManagerProvider();
        mgrs = this.dlgInputs.poolManagers;
        if (mgrs == null && provider != null) {
            mgrs = provider.getSystemFilterPoolManagers();
        }
        if (mgrs == null && (refmgr = this.getFilterPoolReferenceManager()) != null) {
            mgrs = refmgr.getSystemFilterPoolManagers();
        }
        if (mgrs == null && (sfprmp = this.getReferenceManagerProviderSelection()) != null) {
            mgrs = sfprmp.getSystemFilterPoolReferenceManager().getSystemFilterPoolManagers();
        }
        return mgrs;
    }

    protected ISystemFilterPoolReferenceManagerProvider getReferenceManagerProviderSelection() {
        Object obj = this.getFirstSelection();
        if (obj instanceof ISystemFilterPoolReferenceManagerProvider) {
            return (ISystemFilterPoolReferenceManagerProvider)obj;
        }
        return null;
    }

    public void setFilterPoolManagerNameSelectionIndex(int index) {
        this.dlgInputs.mgrSelection = index;
    }

    public int getFilterPoolManagerNameSelectionIndex() {
        ISystemFilterPoolManager[] mgrs;
        int pos = -1;
        if (this.mgrNamePreselect != null && (mgrs = this.getFilterPoolManagers()) != null) {
            int idx = 0;
            while (pos < 0 && idx < mgrs.length) {
                if (mgrs[idx].getName().equals(this.mgrNamePreselect)) {
                    pos = idx;
                }
                ++idx;
            }
        }
        if (pos < 0) {
            return this.dlgInputs.mgrSelection;
        }
        return pos;
    }

    public void setFilterPoolManagerNamePreSelection(String name) {
        this.mgrNamePreselect = name;
    }

    public void setFilterPoolReferenceManager(ISystemFilterPoolReferenceManager refManager) {
        this.dlgInputs.refManager = refManager;
    }

    public ISystemFilterPoolReferenceManager getFilterPoolReferenceManager() {
        return this.dlgInputs.refManager;
    }

    public void setDialogTitle(String title) {
        this.dlgInputs.title = title;
    }

    public String getDialogTitle() {
        return this.dlgInputs.title;
    }

    public void setDialogPrompt(String prompt) {
        this.dlgInputs.prompt = prompt;
    }

    public String getDialogPrompt() {
        return this.dlgInputs.prompt;
    }

    public void setDialogFilterPoolNamePrompt(String prompt, String tip) {
        this.dlgInputs.poolNamePrompt = prompt;
        this.dlgInputs.poolNameTip = tip;
    }

    public String getDialogFilterPoolNamePrompt() {
        return this.dlgInputs.poolNamePrompt;
    }

    public String getDialogFilterPoolNameTip() {
        return this.dlgInputs.poolNameTip;
    }

    public void setDialogFilterPoolManagerNamePrompt(String prompt, String tip) {
        this.dlgInputs.poolMgrNamePrompt = prompt;
        this.dlgInputs.poolMgrNameTip = tip;
    }

    public String getDialogFilterPoolManagerNamePrompt() {
        return this.dlgInputs.poolMgrNamePrompt;
    }

    public String getDialogFilterPoolManagerNameTip() {
        return this.dlgInputs.poolMgrNameTip;
    }

    public void setDialogPreSelectInput(Object selectData) {
        this.dlgInputs.preSelectObject = selectData;
    }

    public Object getDialogPreSelectInput() {
        return this.dlgInputs.preSelectObject;
    }

    public boolean checkObjectType(Object selectedObject) {
        return selectedObject instanceof ISystemFilterPoolReferenceManagerProvider;
    }

    protected void preSelect(SystemSimpleContentElement inputElement) {
        SystemSimpleContentElement[] mgrElements = inputElement.getChildren();
        int idx = 0;
        while (idx < mgrElements.length) {
            SystemSimpleContentElement[] poolElements = mgrElements[idx].getChildren();
            int jdx = 0;
            while (jdx < poolElements.length) {
                poolElements[jdx].setSelected(this.getFilterPoolPreSelection((ISystemFilterPool)poolElements[jdx].getData()));
                ++jdx;
            }
            ++idx;
        }
    }

    protected boolean getFilterPoolPreSelection(ISystemFilterPool pool) {
        return pool.getReferenceCount() > 0;
    }

    public void run() {
        super.run();
        if (this.getValue() != null) {
            this.doOKprocessing(this.getValue());
        }
    }

    protected Dialog createDialog(Shell parent) {
        SystemFilterPoolDialogInterface fpDlg = this.createFilterPoolDialog(parent);
        fpDlg.setFilterPoolDialogActionCaller(this);
        return (Dialog)fpDlg;
    }

    public abstract SystemFilterPoolDialogInterface createFilterPoolDialog(Shell var1);

    protected abstract Object getDialogValue(Dialog var1);

    public abstract void doOKprocessing(Object var1);
}

