/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.ftp.parser;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.VMSFTPEntryParser;

public class RSEVMSFTPEntryParser
extends VMSFTPEntryParser {
    private static final Pattern PERMISSIONS_PATTERN = Pattern.compile(".*(\\([a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*\\))");

    public FTPFile parseFTPEntry(String entry) {
        FTPFile f = super.parseFTPEntry(entry);
        if (f != null) {
            Matcher m;
            if (!this.isVersioning() && f.getName().lastIndexOf(".DIR") != -1) {
                f.setName(f.getName().substring(0, f.getName().lastIndexOf(".DIR")));
            }
            if ((m = PERMISSIONS_PATTERN.matcher(entry.trim())).matches()) {
                StringTokenizer t = new StringTokenizer(m.group(1), ",");
                t.nextElement();
                int access = 0;
                while (access < 3) {
                    String token = t.nextToken();
                    f.setPermission(access, 0, token.indexOf(82) >= 0);
                    f.setPermission(access, 1, token.indexOf(87) >= 0);
                    f.setPermission(access, 2, token.indexOf(69) >= 0);
                    ++access;
                }
            }
        }
        return f;
    }
}

