/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.markdown.marked;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.markdown.marked.HTMLRenderer;
import org.eclipse.tm4e.markdown.marked.Helpers;
import org.eclipse.tm4e.markdown.marked.IRenderer;
import org.eclipse.tm4e.markdown.marked.InlineRules;
import org.eclipse.tm4e.markdown.marked.Options;

public class InlineLexer {
    private final Options options;
    private final InlineRules rules;
    private final IRenderer renderer;

    public InlineLexer(@Nullable Object links, @Nullable Options options, @Nullable IRenderer renderer) {
        this.options = options != null ? options : Options.DEFAULTS;
        IRenderer iRenderer = this.renderer = renderer != null ? renderer : new HTMLRenderer();
        this.rules = this.options.isGfm() ? (this.options.isBreaks() ? InlineRules.breaks : InlineRules.gfm) : (this.options.isPedantic() ? InlineRules.pedantic : InlineRules.normal);
    }

    public void output(String src) {
        Matcher cap = null;
        while (!Strings.isNullOrEmpty((String)src)) {
            cap = this.rules.strong.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                this.renderer.startStrong();
                this.output(!Strings.isNullOrEmpty((String)cap.group(2)) ? cap.group(2) : cap.group(1));
                this.renderer.endStrong();
                continue;
            }
            cap = this.rules.em.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                this.renderer.startEm();
                this.output(!Strings.isNullOrEmpty((String)cap.group(2)) ? cap.group(2) : cap.group(1));
                this.renderer.endEm();
                continue;
            }
            cap = this.rules.code.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                this.renderer.codespan(Helpers.htmlEscape(cap.group(2), true));
                continue;
            }
            cap = this.rules.text.exec(src);
            if (cap == null) continue;
            src = src.substring(cap.group(0).length());
            this.renderer.text(Helpers.htmlEscape(this.smartypants(cap.group(0))));
        }
    }

    private String smartypants(String text) {
        return text;
    }
}

