import { Logger } from 'vscode-debugadapter';
import * as telemetry from '../telemetry';
import { IStepStartedEventsEmitter, StepProgressEventsEmitter, IObservableEvents } from '../executionTimingsReporter';
import { ITargetDiscoveryStrategy, ITargetFilter, ITarget } from './chromeConnection';
export declare class Version {
    private _major;
    private _minor;
    static parse(versionString: string): Version;
    static unknownVersion(): Version;
    constructor(_major: number, _minor: number);
    isAtLeastVersion(major: number, minor: number): boolean;
}
export declare class TargetVersions {
    readonly protocol: Version;
    readonly browser: Version;
    constructor(protocol: Version, browser: Version);
}
export declare class ChromeTargetDiscovery implements ITargetDiscoveryStrategy, IObservableEvents<IStepStartedEventsEmitter> {
    private logger;
    private telemetry;
    readonly events: StepProgressEventsEmitter;
    constructor(_logger: Logger.ILogger, _telemetry: telemetry.ITelemetryReporter);
    getTarget(address: string, port: number, targetFilter?: ITargetFilter, targetUrl?: string): Promise<ITarget>;
    getAllTargets(address: string, port: number, targetFilter?: ITargetFilter, targetUrl?: string): Promise<ITarget[]>;
    private _getVersionData(address, port);
    private _getTargets(address, port);
    private _getMatchingTargets(targets, targetFilter?, targetUrl?);
    private _fixRemoteUrl(remoteAddress, remotePort, target);
}
export declare function removeTitleProperty(targetsResponse: string): string;
