/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.menus.ControlContributionRegistry;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class CompatibilityWorkbenchWindowControlContribution {
    public static final String CONTROL_CONTRIBUTION_URI = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.menus.CompatibilityWorkbenchWindowControlContribution";
    private WorkbenchWindowControlContribution contribution;

    @PostConstruct
    void construct(MWindow window, MToolControl toolControl, Composite composite) {
        IConfigurationElement configurationElement = ControlContributionRegistry.get(toolControl.getElementId());
        if (configurationElement != null) {
            this.contribution = (WorkbenchWindowControlContribution)((Object)Util.safeLoadExecutableExtension(configurationElement, "class", WorkbenchWindowControlContribution.class));
            if (this.contribution != null) {
                IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)window.getContext().get(IWorkbenchWindow.class);
                this.contribution.setWorkbenchWindow(workbenchWindow);
                if (this.contribution instanceof IWorkbenchContribution) {
                    ((IWorkbenchContribution)((Object)this.contribution)).initialize(workbenchWindow);
                }
                MElementContainer parent = toolControl.getParent();
                while (!(parent instanceof MTrimBar) && parent != null) {
                    parent = parent.getParent();
                }
                if (parent != null) {
                    switch (((MTrimBar)parent).getSide()) {
                        case BOTTOM: {
                            this.contribution.setCurSide(1024);
                            break;
                        }
                        case LEFT: {
                            this.contribution.setCurSide(16384);
                            break;
                        }
                        case RIGHT: {
                            this.contribution.setCurSide(131072);
                            break;
                        }
                        case TOP: {
                            this.contribution.setCurSide(128);
                        }
                    }
                } else {
                    this.contribution.setCurSide(128);
                }
                this.contribution.delegateCreateControl(composite);
            }
        }
    }

    @PreDestroy
    void dispose() {
        if (this.contribution != null) {
            this.contribution.dispose();
            this.contribution = null;
        }
    }
}

