/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.wikitext.asciidoc.AsciiDocLanguage;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;

public class AsciiDocIdGenerationStrategy
extends IdGenerationStrategy {
    private final Set<String> existingIds = new HashSet<String>();
    private String idPrefix = "_";
    private String idSeparator = "_";

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    public void setIdSeparator(String idSeparator) {
        this.idSeparator = idSeparator;
    }

    public String generateId(String headingText) {
        String baseId;
        String id = baseId = AsciiDocIdGenerationStrategy.computeHeadingId(headingText, this.idPrefix, this.idSeparator);
        int counter = 2;
        while (this.existingIds.contains(id)) {
            id = baseId + this.idSeparator + counter;
            ++counter;
        }
        this.existingIds.add(id);
        return id;
    }

    static String computeHeadingId(String text, String idprefix, String idseparator) {
        StringBuilder sb = new StringBuilder();
        if (idprefix != null) {
            sb.append(idprefix);
        }
        String anchor = AsciiDocIdGenerationStrategy.parseToHtml(text);
        if ((anchor = anchor.trim()).startsWith("<p>")) {
            anchor = anchor.substring(3);
        }
        if (anchor.endsWith("</p>")) {
            anchor = anchor.substring(0, anchor.length() - 4);
        }
        anchor = anchor.replaceAll("[^\\w]", " ");
        anchor = anchor.trim();
        anchor = anchor.toLowerCase();
        if (idseparator != null) {
            anchor = anchor.replaceAll("\\s+", idseparator);
        }
        sb.append(anchor);
        return sb.toString();
    }

    private static String parseToHtml(String markup) {
        MarkupParser localParser = new MarkupParser((MarkupLanguage)new AsciiDocLanguage());
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setEmitAsDocument(false);
        localParser.setBuilder((DocumentBuilder)builder);
        localParser.parse(markup);
        return out.toString();
    }
}

