/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets.services;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemPropertySheetForm;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.widgets.GridUtil;
import org.eclipse.rse.ui.widgets.services.ServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceTableContentProvider;
import org.eclipse.rse.ui.widgets.services.ServiceTableLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class ServicesForm
extends SystemBaseForm
implements ICheckStateListener {
    private CheckboxTableViewer _factoryViewer;
    private TreeViewer _serviceViewer;
    private SystemPropertySheetForm _propertiesViewer;
    private String _configurationTooltip = SystemResources.RESID_SERVICESFORM_CONFIGURATION_TOOLTIP;
    private String _serviceTooltip = SystemResources.RESID_SERVICESFORM_SERVICES_TOOLTIP;
    private String _propertiesTooltip = SystemResources.RESID_SERVICESFORM_PROPERTIES_TOOLTIP;
    private Text _descriptionVerbiage;

    public ServicesForm(Shell shell, ISystemMessageLine msgLine) {
        super(shell, msgLine);
    }

    public Control createContents(Composite parent) {
        SashForm sashCompositeParent = new SashForm(parent, 256);
        GridData data = new GridData(4, 4, true, true);
        sashCompositeParent.setLayoutData((Object)data);
        SashForm sashCompositeLeft = new SashForm((Composite)sashCompositeParent, 512);
        data = new GridData(4, 4, true, true);
        sashCompositeLeft.setLayoutData((Object)data);
        Composite factoryViewerComposite = new Composite((Composite)sashCompositeLeft, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        factoryViewerComposite.setLayout((Layout)layout);
        factoryViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label factoryLabel = new Label(factoryViewerComposite, 0);
        factoryLabel.setText(SystemResources.RESID_PROPERTIES_FACTORIES_LABEL);
        factoryLabel.setToolTipText(SystemResources.RESID_PROPERTIES_FACTORIES_TOOLTIP);
        this.createFactoryViewer(factoryViewerComposite);
        Composite serviceViewerComposite = new Composite((Composite)sashCompositeLeft, 0);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        serviceViewerComposite.setLayout((Layout)layout);
        serviceViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label servicesLabel = new Label(serviceViewerComposite, 0);
        servicesLabel.setText(SystemResources.RESID_PROPERTIES_SERVICES_LABEL);
        this.createServiceViewer(serviceViewerComposite);
        sashCompositeLeft.setWeights(new int[]{50, 50});
        Composite servicePropertiesComposite = new Composite((Composite)sashCompositeParent, 0);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        servicePropertiesComposite.setLayout((Layout)layout);
        servicePropertiesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label propertiesLabel = new Label(servicePropertiesComposite, 0);
        propertiesLabel.setText(SystemResources.RESID_PROPERTIES_PROPERTIES_LABEL);
        this.createPropertiesViewer(servicePropertiesComposite);
        sashCompositeParent.setWeights(new int[]{40, 60});
        Composite descriptionComposite = new Composite(parent, 0);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        descriptionComposite.setLayout((Layout)layout);
        descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label descriptionLabel = new Label(descriptionComposite, 0);
        descriptionLabel.setText(SystemResources.RESID_PROPERTIES_DESCRIPTION_LABEL);
        this._descriptionVerbiage = new Text(parent, 2120);
        this._descriptionVerbiage.setText(this.getCurrentVerbiage());
        this._descriptionVerbiage.setEditable(false);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 150;
        this._descriptionVerbiage.setLayoutData((Object)gridData);
        this._factoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss;
                ServiceElement firstElement;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && (firstElement = (ServiceElement)(ss = (StructuredSelection)selection).getFirstElement()) != null) {
                    ServicesForm.this._factoryViewer.setChecked((Object)firstElement, true);
                    ServicesForm.this.unCheckOthers(firstElement);
                    if (!firstElement.isSelected()) {
                        firstElement.setSelected(true);
                    }
                    ServicesForm.this._serviceViewer.setInput((Object)firstElement);
                    ServicesForm.this._descriptionVerbiage.setText(ServicesForm.this.getCurrentVerbiage());
                }
            }
        });
        this._serviceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                ServicesForm.this._propertiesViewer.selectionChanged(selection);
                ServicesForm.this._descriptionVerbiage.setText(ServicesForm.this.getCurrentVerbiage());
            }
        });
        return this._factoryViewer.getControl();
    }

    private void createFactoryViewer(Composite parent) {
        this._factoryViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2056);
        this._factoryViewer.addCheckStateListener((ICheckStateListener)this);
        Table table = this._factoryViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GridData data = GridUtil.createFill();
        data.heightHint = 20;
        data.widthHint = 30;
        table.setLayoutData((Object)data);
        table.setToolTipText(this._configurationTooltip);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        this._factoryViewer.setContentProvider((IContentProvider)new ServiceTableContentProvider());
        this._factoryViewer.setLabelProvider((IBaseLabelProvider)new ServiceTableLabelProvider());
    }

    private void createServiceViewer(Composite parent) {
        this._serviceViewer = new TreeViewer(parent, 2048);
        Tree tableTree = this._serviceViewer.getTree();
        GridData data = GridUtil.createFill();
        data.heightHint = 20;
        data.widthHint = 30;
        tableTree.setLayoutData((Object)data);
        tableTree.setLayout((Layout)new GridLayout());
        tableTree.setToolTipText(this._serviceTooltip);
        this._serviceViewer.setAutoExpandLevel(-1);
        this._serviceViewer.setContentProvider((IContentProvider)new ServiceTableContentProvider());
        this._serviceViewer.setLabelProvider((IBaseLabelProvider)new ServiceTableLabelProvider());
    }

    private void createPropertiesViewer(Composite parent) {
        this._propertiesViewer = new SystemPropertySheetForm(this.getShell(), parent, 2048, this.getMessageLine());
        this._propertiesViewer.setToolTipText(this._propertiesTooltip);
    }

    public void init(ServiceElement root) {
        this._factoryViewer.setInput((Object)root);
        TableItem[] items = this._factoryViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            ServiceElement element = (ServiceElement)item.getData();
            if (element.isSelected()) {
                item.setChecked(true);
                this._factoryViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
            ++i;
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        ServiceElement element = (ServiceElement)event.getElement();
        element.setSelected(event.getChecked());
        this._factoryViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        this.unCheckOthers(element);
        this._descriptionVerbiage.setText(this.getCurrentVerbiage());
    }

    protected void unCheckOthers(ServiceElement checkedElement) {
        Object[] checked = this._factoryViewer.getCheckedElements();
        int i = 0;
        while (i < checked.length) {
            ServiceElement oldChecked = (ServiceElement)checked[i];
            if (oldChecked != checkedElement) {
                oldChecked.setSelected(false);
                this._factoryViewer.setChecked((Object)oldChecked, false);
            }
            ++i;
        }
    }

    public ServiceElement getSelectedService() {
        return (ServiceElement)this._factoryViewer.getCheckedElements()[0];
    }

    public boolean verify() {
        return this._factoryViewer.getCheckedElements().length > 0;
    }

    protected String getCurrentVerbiage() {
        String description = null;
        if (this._serviceViewer != null) {
            IStructuredSelection factorySelection;
            IStructuredSelection serviceSelection = (IStructuredSelection)this._serviceViewer.getSelection();
            if (serviceSelection != null && !serviceSelection.isEmpty()) {
                description = ((ServiceElement)serviceSelection.getFirstElement()).getDescription();
            } else if (this._factoryViewer != null && (factorySelection = (IStructuredSelection)this._factoryViewer.getSelection()) != null && !factorySelection.isEmpty()) {
                description = ((ServiceElement)factorySelection.getFirstElement()).getDescription();
            }
        }
        return description != null ? description : "";
    }
}

