/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.themes;

import java.io.InputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.registry.TMResource;
import org.eclipse.tm4e.ui.themes.ColorManager;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.ITokenProvider;
import org.eclipse.tm4e.ui.themes.css.CSSTokenProvider;

public class Theme
extends TMResource
implements ITheme {
    private static final String DARK_ATTR = "dark";
    private static final String DEFAULT_ATTR = "default";
    private ITokenProvider tokenProvider;
    private String id;
    private String name;
    private boolean dark;
    private boolean isDefault;

    public Theme() {
    }

    public Theme(String id, String path, String name, boolean dark, boolean isDefault) {
        super(path);
        this.id = id;
        this.name = name;
        this.dark = dark;
        this.isDefault = isDefault;
    }

    public Theme(IConfigurationElement ce) {
        super(ce);
        this.id = ce.getAttribute("id");
        this.name = ce.getAttribute("name");
        this.dark = Boolean.parseBoolean(ce.getAttribute(DARK_ATTR));
        this.isDefault = Boolean.parseBoolean(ce.getAttribute(DEFAULT_ATTR));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IToken getToken(String type) {
        ITokenProvider provider = this.getTokenProvider();
        return provider != null ? provider.getToken(type) : null;
    }

    @Override
    public Color getEditorForeground() {
        ITokenProvider provider = this.getTokenProvider();
        Color themeColor = provider != null ? provider.getEditorForeground() : null;
        return ColorManager.getInstance().getPriorityColor(themeColor, "AbstractTextEditor.Color.Foreground");
    }

    @Override
    public Color getEditorBackground() {
        ITokenProvider provider = this.getTokenProvider();
        Color themeColor = provider != null ? provider.getEditorBackground() : null;
        return ColorManager.getInstance().getPriorityColor(themeColor, "AbstractTextEditor.Color.Background");
    }

    @Override
    public Color getEditorSelectionForeground() {
        ITokenProvider provider = this.getTokenProvider();
        Color themeColor = provider != null ? provider.getEditorSelectionForeground() : null;
        return ColorManager.getInstance().getPriorityColor(themeColor, "AbstractTextEditor.Color.SelectionForeground");
    }

    @Override
    public Color getEditorSelectionBackground() {
        ITokenProvider provider = this.getTokenProvider();
        Color themeColor = provider != null ? provider.getEditorSelectionBackground() : null;
        return ColorManager.getInstance().getPriorityColor(themeColor, "AbstractTextEditor.Color.SelectionBackground");
    }

    @Override
    public Color getEditorCurrentLineHighlight() {
        ITokenProvider provider = this.getTokenProvider();
        Color themeColor = provider != null ? provider.getEditorCurrentLineHighlight() : null;
        ColorManager manager = ColorManager.getInstance();
        return manager.isColorUserDefined("AbstractTextEditor.Color.Background") ? manager.getPreferenceEditorColor("currentLineColor") : themeColor;
    }

    private ITokenProvider getTokenProvider() {
        if (this.tokenProvider == null) {
            InputStream in;
            block4: {
                in = super.getInputStream();
                if (in != null) break block4;
                return null;
            }
            try {
                this.tokenProvider = new CSSTokenProvider(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.tokenProvider;
    }

    @Override
    public String toCSSStyleSheet() {
        return super.getResourceContent();
    }

    @Override
    public boolean isDark() {
        return this.dark;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void initializeViewerColors(StyledText styledText) {
        Color color = this.getEditorBackground();
        if (color != null) {
            styledText.setBackground(color);
        }
        if ((color = this.getEditorForeground()) != null) {
            styledText.setForeground(color);
        }
        if ((color = this.getEditorSelectionBackground()) != null) {
            styledText.setSelectionBackground(color);
        }
        if ((color = this.getEditorSelectionForeground()) != null) {
            styledText.setSelectionForeground(color);
        }
    }
}

