/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.preferences;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tm.internal.terminal.control.impl.TerminalMessages;
import org.eclipse.tm.internal.terminal.model.SystemDefaultColors;
import org.eclipse.tm.terminal.model.TerminalColor;

public enum TerminalColorPresets {
    INSTANCE;

    private final List<Preset> presets = new ArrayList<Preset>();

    public List<String> getPresets() {
        return this.presets.stream().map(Preset::getName).collect(Collectors.toList());
    }

    public Preset getPreset(int index) {
        return this.presets.get(index);
    }

    private TerminalColorPresets() {
        this.presets.add(new Preset(TerminalMessages.TerminalColorPresets_TerminalDefaults));
        this.presets.add(new Preset(TerminalMessages.TerminalColorPresets_EclipseLight).set(TerminalColor.FOREGROUND, this.getDefaultPreset().getRGB(TerminalColor.BLACK)).set(TerminalColor.BACKGROUND, this.getDefaultPreset().getRGB(TerminalColor.WHITE)));
        this.presets.add(new Preset(TerminalMessages.TerminalColorPresets_EclipseDark).set(TerminalColor.FOREGROUND, this.getDefaultPreset().getRGB(TerminalColor.WHITE)).set(TerminalColor.BACKGROUND, this.getDefaultPreset().getRGB(TerminalColor.BLACK)));
    }

    public Preset getDefaultPreset() {
        return this.presets.get(0);
    }

    public static class Preset {
        private String name;
        private Map<TerminalColor, Supplier<RGB>> map = new EnumMap<TerminalColor, Supplier<RGB>>(TerminalColor.class);

        Preset(String name) {
            this.name = name;
            this.set(TerminalColor.BLACK, 0, 0, 0);
            this.set(TerminalColor.RED, 205, 0, 0);
            this.set(TerminalColor.GREEN, 0, 205, 0);
            this.set(TerminalColor.YELLOW, 205, 205, 0);
            this.set(TerminalColor.BLUE, 0, 0, 238);
            this.set(TerminalColor.MAGENTA, 205, 0, 205);
            this.set(TerminalColor.CYAN, 0, 205, 205);
            this.set(TerminalColor.WHITE, 229, 229, 229);
            this.set(TerminalColor.BRIGHT_BLACK, 0, 0, 0);
            this.set(TerminalColor.BRIGHT_RED, 255, 0, 0);
            this.set(TerminalColor.BRIGHT_GREEN, 0, 255, 0);
            this.set(TerminalColor.BRIGHT_YELLOW, 255, 255, 0);
            this.set(TerminalColor.BRIGHT_BLUE, 92, 92, 255);
            this.set(TerminalColor.BRIGHT_MAGENTA, 255, 0, 255);
            this.set(TerminalColor.BRIGHT_CYAN, 0, 255, 255);
            this.set(TerminalColor.BRIGHT_WHITE, 255, 255, 255);
            this.set(TerminalColor.FOREGROUND, SystemDefaultColors.FOREGROUND);
            this.set(TerminalColor.BACKGROUND, SystemDefaultColors.BACKGROUND);
            this.set(TerminalColor.SELECTION_FOREGROUND, SystemDefaultColors.SELECTION_FOREGROUND);
            this.set(TerminalColor.SELECTION_BACKGROUND, SystemDefaultColors.SELECTION_BACKGROUND);
        }

        Preset set(TerminalColor color, RGB rgb) {
            return this.set(color, () -> rgb);
        }

        Preset set(TerminalColor color, int r, int g, int b) {
            return this.set(color, new RGB(r, g, b));
        }

        Preset set(TerminalColor color, Supplier<RGB> rgbSupplier) {
            this.map.put(color, rgbSupplier);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public RGB getRGB(TerminalColor terminalColor) {
            return this.map.getOrDefault((Object)terminalColor, () -> new RGB(0, 0, 0)).get();
        }
    }
}

