/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.AbstractDebugAdapterLaunchShortcut;

public abstract class AbstractHTMLDebugAdapterLaunchShortcut
extends AbstractDebugAdapterLaunchShortcut {
    public AbstractHTMLDebugAdapterLaunchShortcut(String launchConfigTypeId) {
        super(launchConfigTypeId, "org.eclipse.wildwebdeveloper.html", true);
    }

    @Override
    public boolean canLaunchResource(IResource resource) {
        if (resource instanceof IContainer) {
            return this.getLaunchableResource((IContainer)Adapters.adapt((Object)resource, IContainer.class)) != null;
        }
        return super.canLaunchResource(resource);
    }

    @Override
    public void configureLaunchConfiguration(File file, ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("program", file.getAbsolutePath());
        wc.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", file.getParentFile().getAbsolutePath());
    }

    @Override
    public boolean match(ILaunchConfiguration launchConfig, File selectedFile) {
        try {
            return launchConfig.getAttribute("program", "").equals(selectedFile.getAbsolutePath());
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            return false;
        }
    }

    @Override
    public IResource getLaunchableResource(IContainer container) {
        try {
            if (container.members().length == 1 && container.members()[0].getName().matches(".*\\.html$")) {
                return container.members()[0];
            }
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource projItem = iResourceArray[n2];
                if (projItem.getName().equals("index.html")) {
                    return projItem;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }
}

