/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.TextEditorAction;

@Deprecated(forRemoval=true)
public class EncodingActionGroup
extends ActionGroup {
    private static final String FILE_CONTENT_ENCODING_FORMAT = TextEditorMessages.ResourceInfo_fileContentEncodingFormat;
    private static final String FILE_CONTAINER_ENCODING_FORMAT = TextEditorMessages.ResourceInfo_fileContainerEncodingFormat;
    private static final String[][] ENCODINGS;
    private static final String SYSTEM_ENCODING;
    private List<RetargetTextEditorAction> fRetargetActions = new ArrayList<RetargetTextEditorAction>();
    private ITextEditor fTextEditor;

    static {
        String[][] encodings = new String[][]{{"default", "org.eclipse.ui.default_action_context", "org.eclipse.ui.edit.text.encoding.default"}, {"US-ASCII", "org.eclipse.ui.US-ASCII_action_context", "org.eclipse.ui.edit.text.encoding.us-ascii"}, {"ISO-8859-1", "org.eclipse.ui.ISO-8859-1_action_context", "org.eclipse.ui.edit.text.encoding.iso-8859-1"}, {"UTF-8", "org.eclipse.ui.UTF-8_action_context", "org.eclipse.ui.edit.text.encoding.utf-8"}, {"UTF-16BE", "org.eclipse.ui.UTF-16BE_action_context", "org.eclipse.ui.edit.text.encoding.utf-16be"}, {"UTF-16LE", "org.eclipse.ui.UTF-16LE_action_context", "org.eclipse.ui.edit.text.encoding.utf-16le"}, {"UTF-16", "org.eclipse.ui.UTF-16_action_context", "org.eclipse.ui.edit.text.encoding.utf-16"}};
        String system = System.getProperty("file.encoding");
        if (system != null) {
            int i = 0;
            while (i < encodings.length) {
                if (encodings[i][0].equals(system)) break;
                ++i;
            }
            if (i != encodings.length) {
                String[] s = encodings[i];
                encodings[i] = encodings[1];
                encodings[1] = s;
                system = null;
            }
        }
        SYSTEM_ENCODING = system;
        ENCODINGS = encodings;
    }

    private static String getDefaultEncodingText(ITextEditor editor, String defaultText) {
        String encoding;
        IEditorInput input = editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return defaultText;
        }
        IFile file = ((IFileEditorInput)input).getFile();
        String format = FILE_CONTENT_ENCODING_FORMAT;
        try {
            encoding = EncodingActionGroup.getEncodingFromContent(file);
            if (encoding == null) {
                format = FILE_CONTAINER_ENCODING_FORMAT;
                encoding = file.getParent().getDefaultCharset();
            }
        }
        catch (CoreException coreException) {
            return defaultText;
        }
        return NLSUtility.format(format, encoding);
    }

    private static String getEncodingFromContent(IFile file) throws CoreException {
        IContentDescription description = file.getContentDescription();
        if (description != null) {
            byte[] bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK);
            if (bom == null) {
                return (String)description.getProperty(IContentDescription.CHARSET);
            }
            if (bom == IContentDescription.BOM_UTF_8) {
                return TextEditorMessages.WorkbenchPreference_encoding_BOM_UTF_8;
            }
            if (bom == IContentDescription.BOM_UTF_16BE) {
                return TextEditorMessages.WorkbenchPreference_encoding_BOM_UTF_16BE;
            }
            if (bom == IContentDescription.BOM_UTF_16LE) {
                return TextEditorMessages.WorkbenchPreference_encoding_BOM_UTF_16LE;
            }
        }
        return null;
    }

    public EncodingActionGroup() {
        this.fRetargetActions.add(new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding." + ENCODINGS[0][0] + ".", ENCODINGS[0][0], 8));
        if (SYSTEM_ENCODING != null) {
            this.fRetargetActions.add(new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding.System.", "System", 8));
        }
        int i = 1;
        while (i < ENCODINGS.length) {
            this.fRetargetActions.add(new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding." + ENCODINGS[i][0] + ".", ENCODINGS[i][0], 8));
            ++i;
        }
        this.fRetargetActions.add(new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding.Custom.", "Custom", 1));
    }

    public void fillActionBars(IActionBars actionBars) {
        IMenuManager menuManager = actionBars.getMenuManager();
        IMenuManager editMenu = menuManager.findMenuUsingPath("edit");
        if (editMenu != null && !this.fRetargetActions.isEmpty()) {
            MenuManager subMenu = new MenuManager(TextEditorMessages.Editor_ConvertEncoding_submenu_label);
            subMenu.addMenuListener(manager -> this.update());
            Iterator<RetargetTextEditorAction> e = this.fRetargetActions.iterator();
            subMenu.add((IAction)e.next());
            subMenu.add((IContributionItem)new Separator());
            while (e.hasNext()) {
                subMenu.add((IAction)e.next());
            }
            editMenu.add((IContributionItem)subMenu);
        }
    }

    public void retarget(ITextEditor editor) {
        this.fTextEditor = editor;
        for (RetargetTextEditorAction a : this.fRetargetActions) {
            a.setAction(editor == null ? null : editor.getAction(a.getId()));
        }
    }

    public EncodingActionGroup(ITextEditor editor) {
        TextEditorAction a;
        this.fTextEditor = editor;
        if (SYSTEM_ENCODING != null) {
            a = new PredefinedEncodingAction(TextEditorMessages.getBundleForConstructedKeys(), SYSTEM_ENCODING, editor);
            a.setHelpContextId("org.eclipse.ui.System_action_context");
            a.setActionDefinitionId("org.eclipse.ui.edit.text.encoding.system");
            editor.setAction("System", (IAction)a);
        }
        String[][] stringArray = ENCODINGS;
        int n = ENCODINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] e = stringArray[n2];
            a = new PredefinedEncodingAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding." + e[0] + ".", e[0], editor);
            a.setHelpContextId(e[1]);
            a.setActionDefinitionId(e[2]);
            editor.setAction(e[0], (IAction)a);
            ++n2;
        }
        a = new CustomEncodingAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding.Custom.", editor);
        a.setHelpContextId("org.eclipse.ui.Custom_action_context");
        a.setActionDefinitionId("org.eclipse.ui.edit.text.encoding.custom");
        editor.setAction("Custom", (IAction)a);
    }

    public void update() {
        if (this.fTextEditor == null) {
            return;
        }
        IAction a = this.fTextEditor.getAction("System");
        if (a instanceof IUpdate) {
            ((IUpdate)a).update();
        }
        String[][] stringArray = ENCODINGS;
        int n = ENCODINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] e = stringArray[n2];
            a = this.fTextEditor.getAction(e[0]);
            if (a instanceof IUpdate) {
                ((IUpdate)a).update();
            }
            ++n2;
        }
        a = this.fTextEditor.getAction("Custom");
        if (a instanceof IUpdate) {
            ((IUpdate)a).update();
        }
    }

    public void dispose() {
        if (this.fTextEditor != null) {
            this.fTextEditor.setAction("System", null);
            String[][] stringArray = ENCODINGS;
            int n = ENCODINGS.length;
            int n2 = 0;
            while (n2 < n) {
                String[] e = stringArray[n2];
                this.fTextEditor.setAction(e[0], null);
                ++n2;
            }
            this.fTextEditor.setAction("Custom", null);
            this.fTextEditor = null;
        }
    }

    static class CustomEncodingAction
    extends TextEditorAction {
        protected CustomEncodingAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void update() {
            ITextEditor editor = this.getTextEditor();
            this.setEnabled(editor != null && !editor.isDirty());
        }

        public void run() {
            InputDialog d;
            ITextEditor editor = this.getTextEditor();
            if (editor == null) {
                return;
            }
            IEncodingSupport encodingSupport = (IEncodingSupport)editor.getAdapter(IEncodingSupport.class);
            if (encodingSupport == null) {
                return;
            }
            String title = TextEditorMessages.Editor_ConvertEncoding_Custom_dialog_title;
            String message = TextEditorMessages.Editor_ConvertEncoding_Custom_dialog_message;
            IInputValidator inputValidator = newText -> newText == null || newText.isEmpty() ? " " : null;
            String initialValue = encodingSupport.getEncoding();
            if (initialValue == null) {
                initialValue = encodingSupport.getDefaultEncoding();
            }
            if (initialValue == null) {
                initialValue = "";
            }
            if ((d = new InputDialog(editor.getSite().getShell(), title, message, initialValue, inputValidator)).open() == 0) {
                encodingSupport.setEncoding(d.getValue());
            }
        }
    }

    static class PredefinedEncodingAction
    extends TextEditorAction {
        private String fEncoding;
        private String fLabel;
        private boolean fIsDefault;

        public PredefinedEncodingAction(ResourceBundle bundle, String prefix, String encoding, ITextEditor editor) {
            super(bundle, prefix, editor);
            this.fEncoding = encoding;
            if (prefix == null) {
                this.setText(encoding);
            }
            this.fLabel = this.getText();
        }

        public PredefinedEncodingAction(ResourceBundle bundle, String encoding, ITextEditor editor) {
            super(bundle, null, editor);
            this.fEncoding = encoding;
            this.setText(encoding);
            this.fLabel = this.getText();
        }

        private IEncodingSupport getEncodingSupport() {
            ITextEditor editor = this.getTextEditor();
            if (editor != null) {
                return (IEncodingSupport)editor.getAdapter(IEncodingSupport.class);
            }
            return null;
        }

        public void run() {
            IEncodingSupport s = this.getEncodingSupport();
            if (s != null) {
                s.setEncoding(this.fIsDefault ? null : this.fEncoding);
            }
        }

        private String getEncoding(ITextEditor editor) {
            IEncodingSupport s;
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                try {
                    String explicitEncoding = file.getCharset(false);
                    if (explicitEncoding == null) {
                        return null;
                    }
                }
                catch (CoreException coreException) {}
            }
            if ((s = this.getEncodingSupport()) != null) {
                return s.getEncoding();
            }
            return null;
        }

        public void update() {
            if (this.fEncoding == null) {
                this.setEnabled(false);
                return;
            }
            ITextEditor editor = this.getTextEditor();
            if (editor == null) {
                this.setEnabled(false);
                return;
            }
            this.fIsDefault = "default".equals(this.fEncoding);
            if (this.fIsDefault) {
                this.setText(EncodingActionGroup.getDefaultEncodingText(editor, this.fLabel));
            } else {
                this.setText(this.fLabel);
            }
            if (editor.isDirty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            String current = this.getEncoding(editor);
            if (this.fIsDefault) {
                this.setChecked(current == null);
            } else {
                this.setChecked(this.fEncoding.equals(current));
            }
        }
    }
}

