/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CompareRevisionAction
extends BaseSelectionListenerAction {
    HistoryPage page;
    IStructuredSelection selection;
    IFileRevision currentFileRevision;

    public CompareRevisionAction(String text, HistoryPage page) {
        super(text);
        this.page = page;
    }

    public CompareRevisionAction(HistoryPage page) {
        this(TeamUIMessages.LocalHistoryPage_CompareAction, page);
    }

    public void run() {
        IStructuredSelection structSel = this.selection;
        if (structSel == null) {
            return;
        }
        Object[] objArray = structSel.toArray();
        IFileRevision file1 = null;
        IFileRevision file2 = null;
        switch (structSel.size()) {
            case 1: {
                file1 = this.getCurrentFileRevision();
                Object tempRevision = objArray[0];
                if (tempRevision instanceof IFileRevision) {
                    file2 = (IFileRevision)tempRevision;
                    break;
                }
                return;
            }
            case 2: {
                Object tempRevision2 = objArray[0];
                Object tempRevision3 = objArray[1];
                if (tempRevision2 instanceof IFileRevision && tempRevision3 instanceof IFileRevision) {
                    file1 = (IFileRevision)objArray[0];
                    file2 = (IFileRevision)objArray[1];
                    break;
                }
                return;
            }
        }
        if (file1 == null || file2 == null || !file1.exists() || !file2.exists()) {
            MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)TeamUIMessages.OpenRevisionAction_DeletedRevTitle, (String)TeamUIMessages.CompareRevisionAction_DeleteCompareMessage);
            return;
        }
        IResource resource = this.getResource(file2);
        if (resource != null) {
            IFileRevision temp = file1;
            file1 = file2;
            file2 = temp;
        }
        Object left = (resource = this.getResource(file1)) != null ? this.getElementFor(resource) : new FileRevisionTypedElement(file1, this.getLocalEncoding());
        FileRevisionTypedElement right = new FileRevisionTypedElement(file2, this.getLocalEncoding());
        this.openInCompare((ITypedElement)left, right);
    }

    private String getLocalEncoding() {
        IResource resource = this.getResource(this.getCurrentFileRevision());
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                return file.getCharset();
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return null;
    }

    protected ITypedElement getElementFor(IResource resource) {
        return SaveableCompareEditorInput.createFileElement((IFile)resource);
    }

    private void openInCompare(ITypedElement left, ITypedElement right) {
        CompareFileRevisionEditorInput input = this.createCompareEditorInput(left, right, this.page.getSite().getPage());
        IWorkbenchPage workBenchPage = this.page.getSite().getPage();
        IEditorPart editor = Utils.findReusableCompareEditor(input, workBenchPage, new Class[]{CompareFileRevisionEditorInput.class});
        if (editor != null) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals((Object)input)) {
                if (OpenStrategy.activateOnOpen()) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workBenchPage.bringToTop((IWorkbenchPart)editor);
                }
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                if (OpenStrategy.activateOnOpen()) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workBenchPage.bringToTop((IWorkbenchPart)editor);
                }
            }
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)input, (boolean)OpenStrategy.activateOnOpen());
        }
    }

    protected CompareFileRevisionEditorInput createCompareEditorInput(ITypedElement left, ITypedElement right, IWorkbenchPage page) {
        return new CompareFileRevisionEditorInput(left, right, page);
    }

    private IResource getResource(IFileRevision revision) {
        if (revision instanceof LocalFileRevision) {
            LocalFileRevision local = (LocalFileRevision)revision;
            return local.getFile();
        }
        return null;
    }

    private IFileRevision getCurrentFileRevision() {
        return this.currentFileRevision;
    }

    public void setCurrentFileRevision(IFileRevision fileRevision) {
        this.currentFileRevision = fileRevision;
    }

    @Deprecated
    public static IEditorPart findReusableCompareEditor(IWorkbenchPage workbenchPage) {
        return Utils.findReusableCompareEditor(null, workbenchPage, new Class[]{CompareFileRevisionEditorInput.class});
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        if (selection.size() == 1) {
            Object el = selection.getFirstElement();
            if (el instanceof LocalFileRevision) {
                this.setText(TeamUIMessages.CompareRevisionAction_Local);
            } else if (el instanceof FileRevision) {
                FileRevision tempFileRevision = (FileRevision)el;
                this.setText(NLS.bind((String)TeamUIMessages.CompareRevisionAction_Revision, (Object[])new String[]{tempFileRevision.getContentIdentifier()}));
            } else {
                this.setText(TeamUIMessages.CompareRevisionAction_CompareWithCurrent);
            }
            return this.shouldShow();
        }
        if (selection.size() == 2) {
            this.setText(TeamUIMessages.CompareRevisionAction_CompareWithOther);
            return this.shouldShow();
        }
        return false;
    }

    private boolean shouldShow() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        if (objArray.length == 0) {
            return false;
        }
        Object[] objectArray = objArray;
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof AbstractHistoryCategory) {
                return false;
            }
            IFileRevision revision = (IFileRevision)obj;
            if (revision != null && !revision.exists()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

