/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.ISystemMessageLineTarget;
import org.eclipse.rse.ui.messages.SystemMessageLine;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class SystemBasePropertyPage
extends PropertyPage
implements ISystemMessageLine,
ISystemMessageLineTarget {
    protected ISystemMessageLine msgLine;
    protected boolean msgLineSet = false;
    protected Composite contentArea;
    protected Composite buttonsComposite;
    private Cursor waitCursor;
    private String helpId;

    protected Control createContents(Composite parent) {
        Control c;
        if (!this.wantDefaultAndApplyButton()) {
            this.noDefaultAndApplyButton();
        }
        if ((c = this.createContentArea(parent)) != null && c instanceof Composite) {
            this.contentArea = (Composite)c;
            if (this.helpId != null) {
                SystemWidgetHelpers.setHelp((Control)this.contentArea, this.helpId);
            }
            if (this.wantMnemonics()) {
                new Mnemonics().setOnPreferencePage(true).setMnemonics(this.contentArea);
            }
        }
        this.configureMessageLine();
        return c;
    }

    protected boolean wantDefaultAndApplyButton() {
        return false;
    }

    protected boolean wantMnemonics() {
        return true;
    }

    protected boolean wantAutomaticValidManagement() {
        return true;
    }

    public void setHelp(String helpId) {
        if (this.contentArea != null) {
            SystemWidgetHelpers.setHelp((Control)this.contentArea, helpId);
            SystemWidgetHelpers.setHelp((Control)this.contentArea, helpId);
        }
        this.helpId = helpId;
    }

    protected abstract Control createContentArea(Composite var1);

    protected void configureMessageLine() {
    }

    protected void contributeButtons(Composite buttonBar) {
        this.buttonsComposite = buttonBar;
        if (this.helpId != null) {
            SystemWidgetHelpers.setHelp((Control)this.buttonsComposite, this.helpId);
        }
        if (this.wantDefaultAndApplyButton()) {
            super.contributeButtons(buttonBar);
        } else {
            Composite content = buttonBar.getParent();
            if (this.contentArea != null && this.contentArea.getLayout() != null && this.contentArea.getLayout() instanceof GridLayout) {
                ((GridLayout)this.contentArea.getLayout()).marginHeight = 0;
                if (this.contentArea.getLayoutData() instanceof GridData) {
                    ((GridData)this.contentArea.getLayoutData()).grabExcessVerticalSpace = false;
                }
                this.contentArea.pack();
            }
            if (content != null) {
                content.pack();
            }
        }
    }

    public boolean okToLeave() {
        super.okToLeave();
        boolean ok = this.isValid();
        if (ok) {
            ok = this.verifyPageContents();
        }
        return ok;
    }

    protected abstract boolean verifyPageContents();

    public boolean performOk() {
        boolean oldValid = this.isValid();
        boolean newValid = this.okToLeave();
        this.setValid(oldValid);
        return newValid;
    }

    public void setMessageLine(ISystemMessageLine msgLine) {
        this.msgLine = msgLine;
        this.msgLineSet = msgLine != null;
    }

    public ISystemMessageLine getMessageLine() {
        return this;
    }

    public void setBusyCursor(boolean setBusy) {
        if (setBusy) {
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            SystemPromptDialog.setDisplayCursor(this.getShell(), this.waitCursor);
        } else {
            SystemPromptDialog.setDisplayCursor(this.getShell(), null);
            if (this.waitCursor != null) {
                this.waitCursor.dispose();
            }
            this.waitCursor = null;
        }
    }

    protected Label addSeparatorLine(Composite parent, int nbrColumns) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
        return separator;
    }

    protected Label addFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        filler.setLayoutData((Object)data);
        return filler;
    }

    protected Control grabExcessSpace(Control control) {
        GridData gd = (GridData)control.getLayoutData();
        if (gd != null) {
            gd.grabExcessHorizontalSpace = true;
        }
        return control;
    }

    protected Label createLabeledLabel(Composite c, String label, String tooltip) {
        Label l = SystemWidgetHelpers.createLabeledLabel(c, label, tooltip, false);
        GridData gd = (GridData)l.getLayoutData();
        if (gd != null) {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalIndent = 10;
        }
        return l;
    }

    protected Combo createLabeledCombo(Composite c, String label, String tooltip) {
        Combo combo = SystemWidgetHelpers.createLabeledCombo(c, null, label, tooltip);
        GridData gd = (GridData)combo.getLayoutData();
        if (gd != null) {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalIndent = 10;
        }
        return combo;
    }

    protected Text createLabeledText(Composite c, String label, String tooltip) {
        Text field = SystemWidgetHelpers.createLabeledTextField(c, null, label, tooltip);
        GridData gd = (GridData)field.getLayoutData();
        if (gd != null) {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalIndent = 10;
        }
        return field;
    }

    protected Label createLabeledVerbiage(Composite c, String label, String tooltip) {
        Label verbiage = SystemWidgetHelpers.createLabeledVerbiage(c, label, tooltip, 1, false, 200);
        GridData gd = (GridData)verbiage.getLayoutData();
        if (gd != null) {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalIndent = 10;
        }
        return verbiage;
    }

    public void clearErrorMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearErrorMessage();
        } else {
            super.setErrorMessage(null);
        }
        if (this.wantAutomaticValidManagement()) {
            this.setValid(true);
        }
    }

    public void clearMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearMessage();
        } else {
            super.setMessage(null);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        if (this.msgLine != null) {
            return this.msgLine.getSystemErrorMessage();
        }
        return null;
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
        if (this.wantAutomaticValidManagement()) {
            this.setValid(message == null);
        }
        if (this.msgLine != null) {
            ((SystemMessageLine)this.msgLine).setErrorMessage(message);
        }
    }

    public void setErrorMessage(SystemMessage message) {
        if (this.msgLine != null) {
            this.msgLine.setErrorMessage(message);
        } else {
            super.setErrorMessage(message.getLevelOneText());
        }
        if (this.wantAutomaticValidManagement()) {
            this.setValid(message == null);
        }
    }

    public void setErrorMessage(Throwable exc) {
        if (this.msgLine != null) {
            this.msgLine.setErrorMessage(exc);
        }
    }

    public void setMessage(SystemMessage message) {
        if (this.msgLine != null) {
            this.msgLine.setMessage(message);
        } else {
            super.setMessage(message.getLevelOneText());
        }
    }

    public void setMessage(String message) {
        super.setMessage(message);
        if (this.msgLine != null) {
            ((SystemMessageLine)this.msgLine).setMessage(message);
        }
    }
}

