/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import org.eclipse.rse.ui.MassagerFoldCase;

public class MassagerFoldCaseOutsideQuotes
extends MassagerFoldCase {
    private static final char[] DEFAULT_DELIMITERS = new char[]{'\"', '\''};
    private char[] delimiters;
    private char escape = (char)32;

    public MassagerFoldCaseOutsideQuotes() {
        this(true, DEFAULT_DELIMITERS);
    }

    public MassagerFoldCaseOutsideQuotes(boolean foldToUpperCase) {
        this(foldToUpperCase, DEFAULT_DELIMITERS);
    }

    public MassagerFoldCaseOutsideQuotes(boolean foldToUpperCase, char[] delimiters) {
        super(foldToUpperCase);
        this.setDelimiters(delimiters);
    }

    public void setDelimiters(char[] delimiters) {
        this.delimiters = delimiters;
    }

    public void setEscapeCharacter(char escapeChar) {
        this.escape = escapeChar;
    }

    public char[] getDelimiters() {
        return this.delimiters;
    }

    public char getEscapeCharacter() {
        return this.escape;
    }

    protected String toUpperCase(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        if (!this.hasAnyDelimiters(input)) {
            return input.toUpperCase();
        }
        return this.doFolding(input, true);
    }

    protected String toLowerCase(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        if (!this.hasAnyDelimiters(input)) {
            return input.toLowerCase();
        }
        return this.doFolding(input, false);
    }

    protected boolean hasAnyDelimiters(String input) {
        boolean hasAny = false;
        int idx = 0;
        while (!hasAny && idx < this.delimiters.length) {
            if (input.indexOf(this.delimiters[idx]) != -1) {
                hasAny = true;
            }
            ++idx;
        }
        return hasAny;
    }

    protected String doFolding(String input, boolean upperCase) {
        StringBuffer buffer = new StringBuffer(input.length());
        boolean insideDelimiters = false;
        boolean checkForEscape = this.escape != ' ';
        char currDelimiter = ' ';
        char prevChar = ' ';
        char currChar = ' ';
        int idx = 0;
        while (idx < input.length()) {
            prevChar = currChar;
            currChar = input.charAt(idx);
            if (!insideDelimiters) {
                if (upperCase) {
                    buffer.append(Character.toUpperCase(currChar));
                } else {
                    buffer.append(Character.toLowerCase(currChar));
                }
                if (this.isDelimiter(currChar)) {
                    currDelimiter = currChar;
                    insideDelimiters = true;
                }
            } else {
                buffer.append(currChar);
                if (!(currChar != currDelimiter || checkForEscape && prevChar == this.escape)) {
                    insideDelimiters = false;
                }
            }
            ++idx;
        }
        return buffer.toString();
    }

    protected boolean isDelimiter(char currChar) {
        int idx = 0;
        while (idx < this.delimiters.length) {
            if (currChar == this.delimiters[idx]) {
                return true;
            }
            ++idx;
        }
        return false;
    }
}

