/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.apache.commons.jxpath.ri.model.dom.NamespacePointer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMNamespaceIterator
implements NodeIterator {
    private NodePointer parent;
    private List attributes;
    private int position = 0;

    public DOMNamespaceIterator(NodePointer parent) {
        this.parent = parent;
        this.attributes = new ArrayList();
        this.collectNamespaces(this.attributes, (Node)parent.getNode());
    }

    private void collectNamespaces(List attributes, Node node) {
        Node parent = node.getParentNode();
        if (parent != null) {
            this.collectNamespaces(attributes, parent);
        }
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        }
        if (node.getNodeType() == 1) {
            NamedNodeMap map = node.getAttributes();
            int count = map.getLength();
            for (int i = 0; i < count; ++i) {
                Attr attr = (Attr)map.item(i);
                String prefix = DOMNodePointer.getPrefix(attr);
                String name = DOMNodePointer.getLocalName(attr);
                if ((prefix == null || !prefix.equals("xmlns")) && (prefix != null || !name.equals("xmlns"))) continue;
                attributes.add(attr);
            }
        }
    }

    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        String prefix = "";
        Attr attr = (Attr)this.attributes.get(index);
        String name = attr.getPrefix();
        if (name != null && name.equals("xmlns")) {
            prefix = DOMNodePointer.getLocalName(attr);
        }
        return new NamespacePointer(this.parent, prefix, attr.getValue());
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        this.position = position;
        return position >= 1 && position <= this.attributes.size();
    }
}

