import { SourceMap } from './sourceMap';
import { ISourceMapPathOverrides, IPathMapping } from '../debugAdapterInterfaces';
export declare class SourceMapFactory {
    private _pathMapping;
    private _sourceMapPathOverrides;
    private _enableSourceMapCaching;
    constructor(_pathMapping?: IPathMapping, _sourceMapPathOverrides?: ISourceMapPathOverrides, _enableSourceMapCaching?: boolean);
    /**
     * pathToGenerated - an absolute local path or a URL.
     * mapPath - a path relative to pathToGenerated.
     */
    getMapForGeneratedPath(pathToGenerated: string, originalUrlToGenerated: string | undefined, mapPath: string, isVSClient?: boolean): Promise<SourceMap>;
    /**
     * Parses sourcemap contents from inlined base64-encoded data
     */
    private getInlineSourceMapContents(sourceMapData);
    /**
     * Resolves a sourcemap's path and loads the data
     */
    private getSourceMapContent(pathToGenerated, mapPath);
    private loadSourceMapContents(mapPathOrURL);
    private downloadSourceMapContents(sourceMapUri);
    private _downloadSourceMapContents(sourceMapUri);
}
