/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.wizards.SelectLanguageConfigurationWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;

public class LanguageConfigurationImportWizard
extends Wizard
implements IImportWizard {
    private SelectLanguageConfigurationWizardPage mainPage;
    private ILanguageConfigurationDefinition createdDefinition;
    private ILanguageConfigurationRegistryManager registryManager;
    private final boolean save;

    public LanguageConfigurationImportWizard() {
        this(true);
    }

    public LanguageConfigurationImportWizard(boolean save) {
        this.save = save;
        this.setRegistryManager(LanguageConfigurationRegistryManager.getInstance());
    }

    public void setRegistryManager(ILanguageConfigurationRegistryManager registryManager) {
        this.registryManager = registryManager;
    }

    public void addPages() {
        this.mainPage = new SelectLanguageConfigurationWizardPage(this.registryManager);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        ILanguageConfigurationDefinition definition = this.mainPage.getDefinition();
        this.registryManager.registerLanguageConfigurationDefinition(definition);
        if (this.save) {
            try {
                this.registryManager.save();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
                return false;
            }
        }
        this.createdDefinition = definition;
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public ILanguageConfigurationDefinition getCreatedDefinition() {
        return this.createdDefinition;
    }
}

