/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.filesystem.ui;

import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemProvider;
import org.eclipse.rse.internal.synchronize.filesystem.Policy;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.rse.internal.synchronize.filesystem.ui.FileSystemOperation;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.ui.IWorkbenchPart;

public class PutOperation
extends FileSystemOperation {
    private boolean overwriteIncoming;

    protected PutOperation(IWorkbenchPart part, SubscriberScopeManager manager) {
        super(part, manager);
    }

    protected void execute(FileSystemProvider provider, ResourceTraversal[] traversals, IProgressMonitor monitor) throws CoreException {
        provider.getOperations().checkin(traversals, this.isOverwriteIncoming(), monitor);
        IRemoteFile rootFolder = provider.getRemoteRootFolder().getRemoteFile();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        try {
            rootFolder = rootFolder.getParentRemoteFileSubSystem().getRemoteFileObject(rootFolder.getAbsolutePath(), monitor);
            rootFolder.markStale(true);
            sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)rootFolder, 85, (Object)rootFolder.getAbsolutePath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean hasOutgoingChanges(ResourceTraversal[] traversals) throws CoreException {
        final RuntimeException found = new RuntimeException();
        try {
            FileSystemSubscriber.getInstance().accept(traversals, new IDiffVisitor(){

                public boolean visit(IDiff diff) {
                    IThreeWayDiff twd;
                    if (diff instanceof IThreeWayDiff && ((twd = (IThreeWayDiff)diff).getDirection() == 256 || twd.getDirection() == 768)) {
                        throw found;
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            if (e == found) {
                return true;
            }
            throw e;
        }
        return false;
    }

    protected String getTaskName() {
        return Policy.bind("PutAction.working");
    }

    public boolean isOverwriteIncoming() {
        return this.overwriteIncoming;
    }

    public void setOverwriteIncoming(boolean overwriteIncoming) {
        this.overwriteIncoming = overwriteIncoming;
    }
}

