/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.mpc.ui;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.epp.mpc.ui.IMarketplaceClientService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MarketplaceClient {
    public static void addCatalogDescriptor(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        CatalogRegistry.getInstance().register(catalogDescriptor);
    }

    public static void removeCatalogDescriptor(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        CatalogRegistry.getInstance().unregister(catalogDescriptor);
    }

    public static void openMarketplaceWizard(List<CatalogDescriptor> catalogDescriptors) throws IllegalArgumentException, ExecutionException {
        if (catalogDescriptors != null) {
            if (catalogDescriptors.isEmpty()) {
                throw new IllegalArgumentException();
            }
            for (CatalogDescriptor descriptor : catalogDescriptors) {
                if (descriptor.getUrl() == null) {
                    throw new IllegalArgumentException();
                }
                if (descriptor.getLabel() != null) continue;
                throw new IllegalArgumentException();
            }
        }
        IMarketplaceClientService clientService = MarketplaceClient.getMarketplaceClientService();
        IMarketplaceClientConfiguration config = clientService.newConfiguration();
        if (catalogDescriptors != null) {
            config.setCatalogDescriptors(catalogDescriptors);
        }
        clientService.open(config);
    }

    public static IMarketplaceClientService getMarketplaceClientService() {
        IMarketplaceClientService clientService;
        BundleContext bundleContext = MarketplaceClientUi.getBundleContext();
        ServiceReference serviceReference = bundleContext == null ? null : bundleContext.getServiceReference(IMarketplaceClientService.class);
        IMarketplaceClientService iMarketplaceClientService = clientService = serviceReference == null ? null : (IMarketplaceClientService)bundleContext.getService(serviceReference);
        if (clientService != null) {
            bundleContext.ungetService(serviceReference);
        }
        return clientService;
    }
}

