/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;

public class MemoryRetrievalProxy
extends AbstractModelProxy
implements IMemoryBlockListener {
    private IMemoryBlockRetrieval fRetrieval;

    public MemoryRetrievalProxy(IMemoryBlockRetrieval retrieval) {
        this.fRetrieval = retrieval;
    }

    public void memoryBlocksAdded(IMemoryBlock[] memory) {
        IMemoryBlock[] allMB = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval);
        int lastIndex = allMB.length - memory.length;
        ModelDelta delta = new ModelDelta(this.fRetrieval, 0, 0, allMB.length);
        int i = 0;
        while (i < memory.length) {
            IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(memory[i]);
            if (retrieval != null && retrieval == this.fRetrieval) {
                delta.addNode(memory[i], lastIndex + i, 0x200001, 0);
            }
            ++i;
        }
        this.fireModelChanged(delta);
    }

    public void memoryBlocksRemoved(final IMemoryBlock[] memory) {
        UIJob job = new UIJob("memory blocks removed"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ModelDelta delta = new ModelDelta(MemoryRetrievalProxy.this.fRetrieval, 0);
                IMemoryBlock[] iMemoryBlockArray = memory;
                int n = memory.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemoryBlock block = iMemoryBlockArray[n2];
                    IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(block);
                    if (retrieval != null && retrieval == MemoryRetrievalProxy.this.fRetrieval) {
                        if (MemoryRetrievalProxy.this.isMemoryBlockSelected(MemoryRetrievalProxy.this.getCurrentSelection(), block)) {
                            MemoryRetrievalProxy.this.addSelectDeltaNode(delta);
                        }
                        delta.addNode(block, 2);
                    }
                    ++n2;
                }
                MemoryRetrievalProxy.this.fireModelChanged(delta);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    @Override
    public void init(IPresentationContext context) {
        super.init(context);
        DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this);
    }

    @Override
    public void installed(Viewer viewer) {
        super.installed(viewer);
        this.setInitialSelection();
    }

    protected void setInitialSelection() {
        IMemoryBlock[] allMB = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval);
        if (allMB.length > 0) {
            ModelDelta delta = new ModelDelta(this.fRetrieval, 0, 0, allMB.length);
            delta.addNode(allMB[0], 0, 0x200000, 0);
            this.fireModelChanged(delta);
        }
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
    }

    private void addSelectDeltaNode(ModelDelta delta) {
        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval);
        if (memoryBlocks != null && memoryBlocks.length > 0) {
            delta.addNode(memoryBlocks[0], 0x200000);
        }
    }

    private IStructuredSelection getCurrentSelection() {
        StructuredViewer sv;
        ISelection selection;
        Viewer viewer = this.getViewer();
        if (viewer instanceof StructuredViewer && (selection = (sv = (StructuredViewer)viewer).getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private boolean isMemoryBlockSelected(IStructuredSelection selection, IMemoryBlock memoryBlock) {
        if (!selection.isEmpty()) {
            for (Object sel : selection) {
                if (sel == memoryBlock) {
                    return true;
                }
                if (!(sel instanceof IMemoryRendering) || ((IMemoryRendering)sel).getMemoryBlock() != memoryBlock) continue;
                return true;
            }
        }
        return false;
    }
}

