/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.preferences;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationDefinition;
import org.eclipse.tm4e.ui.utils.ContentTypeHelper;

public class PreferenceHelper {
    private static final Gson DEFAULT_GSON = new GsonBuilder().registerTypeAdapter(LanguageConfigurationDefinition.class, (json, typeOfT, context) -> {
        JsonObject object = json.getAsJsonObject();
        JsonElement pluginId = object.get("pluginId");
        return new LanguageConfigurationDefinition(ContentTypeHelper.getContentTypeById((String)object.get("contentTypeId").getAsString()), object.get("path").getAsString(), pluginId == null ? null : pluginId.getAsString(), object.get("onEnterEnabled").getAsBoolean(), object.get("bracketAutoClosingEnabled").getAsBoolean(), object.get("matchingPairsEnabled").getAsBoolean());
    }).registerTypeAdapter(LanguageConfigurationDefinition.class, (definition, typeOfT, context) -> {
        JsonObject object = new JsonObject();
        object.addProperty("path", definition.getPath());
        object.addProperty("pluginId", definition.getPluginId());
        object.addProperty("contentTypeId", definition.getContentType().getId());
        object.addProperty("onEnterEnabled", definition.isOnEnterEnabled());
        object.addProperty("bracketAutoClosingEnabled", definition.isBracketAutoClosingEnabled());
        object.addProperty("matchingPairsEnabled", definition.isMatchingPairsEnabled());
        return object;
    }).create();

    public static ILanguageConfigurationDefinition[] loadLanguageConfigurationDefinitions(String json) {
        return (ILanguageConfigurationDefinition[])DEFAULT_GSON.fromJson(json, LanguageConfigurationDefinition[].class);
    }

    public static String toJson(Collection<ILanguageConfigurationDefinition> definitions) {
        return DEFAULT_GSON.toJson(definitions);
    }
}

