/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.osgi;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.util.ServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OsgiServiceLocator
extends ServiceLocator {
    private static final String SERVICES_SLASH = "services/";

    public OsgiServiceLocator() {
        this(OsgiServiceLocator.class.getClassLoader());
    }

    public OsgiServiceLocator(ClassLoader classLoader) {
        super(classLoader);
    }

    public static ServiceLocator getApplicableInstance() {
        if (OsgiServiceLocator.isApplicable()) {
            return new OsgiServiceLocator();
        }
        return ServiceLocator.getInstance();
    }

    public static boolean isApplicable() {
        return FrameworkUtil.getBundle(OsgiServiceLocator.class) != null;
    }

    /*
     * Unable to fully structure code
     */
    protected List<ServiceLocator.ResourceDescriptor> discoverServiceResources() {
        resourceUrls = Sets.newHashSet();
        descriptors = new ArrayList<ServiceLocator.ResourceDescriptor>();
        for (Bundle bundle : this.bundles()) {
            for (String resourceName : this.getClasspathServiceResourceNames()) {
                indexOf = resourceName.indexOf("services/");
                Preconditions.checkState((boolean)(indexOf >= 0), (Object)resourceName);
                path = resourceName.substring(0, indexOf + "services/".length() - 1);
                file = resourceName.substring(indexOf + "services/".length());
                resources = bundle.findEntries(path, file, false);
                if (resources != null || (resources = bundle.findEntries("bin/" + path, file, false)) != null) ** GOTO lbl16
                continue;
lbl-1000:
                // 1 sources

                {
                    resourceUrl = (URL)resources.nextElement();
                    if (!resourceUrls.add(resourceUrl)) continue;
                    descriptors.add(new BundleResourceDescriptor(bundle, resourceUrl));
lbl16:
                    // 3 sources

                    ** while (resources.hasMoreElements())
                }
lbl17:
                // 1 sources

            }
        }
        return descriptors;
    }

    protected Class<?> loadClass(ServiceLocator.ResourceDescriptor resource, String className) throws ClassNotFoundException {
        return ((BundleResourceDescriptor)resource).bundle.loadClass(className);
    }

    private Iterable<Bundle> bundles() {
        Bundle[] bundles = this.getContext().getBundles();
        return FluentIterable.from(Arrays.asList(bundles)).filter((Predicate)new SystemBundleFilter());
    }

    BundleContext getContext() {
        Bundle bundle = this.getBundle();
        this.ensureContext(bundle);
        return Objects.requireNonNull(bundle.getBundleContext(), "Bundle has no context");
    }

    protected void ensureContext(Bundle bundle) {
        try {
            bundle.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Bundle getBundle() {
        return Objects.requireNonNull(FrameworkUtil.getBundle(OsgiServiceLocator.class), "Bundle is null.");
    }

    static class BundleResourceDescriptor
    extends ServiceLocator.ResourceDescriptor {
        private final Bundle bundle;

        public BundleResourceDescriptor(Bundle bundle, URL resourceUrl) {
            super(resourceUrl);
            this.bundle = bundle;
        }
    }

    private static class SystemBundleFilter
    implements Predicate<Bundle> {
        private SystemBundleFilter() {
        }

        public boolean apply(Bundle input) {
            return input.getBundleId() != 0L;
        }
    }
}

