/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Base;
import org.apache.tools.ant.taskdefs.optional.perforce.P4HandlerAdapter;
import org.apache.tools.ant.util.StringUtils;

public class SimpleP4OutputHandler
extends P4HandlerAdapter {
    P4Base parent;

    public SimpleP4OutputHandler(P4Base parent) {
        this.parent = parent;
    }

    public void process(String line) throws BuildException {
        if (this.parent.util.match("/^exit/", line)) {
            return;
        }
        if (this.parent.util.match("/^error:/", line) || this.parent.util.match("/^Perforce client error:/", line)) {
            if (!this.parent.util.match("/label in sync/", line) && !this.parent.util.match("/up-to-date/", line)) {
                this.parent.setInError(true);
            } else {
                line = this.parent.util.substitute("s/^[^:]*: //", line);
            }
        } else if (this.parent.util.match("/^info.*?:/", line)) {
            line = this.parent.util.substitute("s/^[^:]*: //", line);
        }
        this.parent.log(line, this.parent.getInError() ? 0 : 2);
        if (this.parent.getInError()) {
            this.parent.setErrorMessage(this.parent.getErrorMessage() + line + StringUtils.LINE_SEP);
        }
    }
}

