/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.wtp.releng.tools.component.IClazzVisitor;
import org.eclipse.wtp.releng.tools.component.IFileLocation;
import org.eclipse.wtp.releng.tools.component.ILibrary;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.internal.FragmentXML;
import org.eclipse.wtp.releng.tools.component.internal.Library;

public class PluginXML
implements IPluginXML {
    protected String name;
    protected String version;
    protected ILocation location;
    protected List libraries;
    protected Set fragments;
    protected List unresolvedLibs;

    public PluginXML(ILocation location) {
        this.location = location;
        this.libraries = new ArrayList(1);
        this.fragments = new HashSet(1);
        this.unresolvedLibs = new ArrayList(1);
    }

    public void addLibrary(String relativePath) {
        IFileLocation fileLocation;
        File file;
        ILocation libraryLocation = this.location.createSibling(relativePath);
        if (libraryLocation instanceof IFileLocation && !(file = (fileLocation = (IFileLocation)libraryLocation).getFile()).exists()) {
            this.unresolvedLibs.add(relativePath);
            System.err.println(file);
        }
        this.addLibrary(new Library(libraryLocation));
    }

    protected void addLibrary(Library library) {
        this.libraries.add(library);
    }

    public List getLibraries() {
        return this.libraries;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addFragment(FragmentXML fragment) {
        this.fragments.add(fragment);
        int size = this.unresolvedLibs.size();
        int i = 0;
        while (i < size) {
            ILocation loc;
            String libPath = (String)this.unresolvedLibs.get(i);
            int begin = libPath.indexOf(36);
            int end = begin != -1 ? libPath.indexOf(36, begin + 1) : -1;
            if (begin != -1 && end != -1) {
                String s = fragment.getFragmentName().substring(this.getName().length() + 1);
                StringBuffer sb = new StringBuffer();
                sb.append(libPath.substring(0, begin));
                sb.append(libPath.substring(begin + 1, end));
                sb.append('/');
                sb.append(s);
                sb.append(libPath.substring(end + 1, libPath.length()));
                libPath = sb.toString();
            }
            if ((loc = fragment.getLocation().createSibling(libPath)) instanceof IFileLocation && ((IFileLocation)loc).getFile().exists()) {
                this.addLibrary(new Library(loc));
                this.unresolvedLibs.remove(i);
                --i;
                --size;
            }
            ++i;
        }
    }

    public Set getFragments() {
        return this.fragments;
    }

    public String getUniqueIdentifier() {
        return String.valueOf(this.getName()) + "_" + this.getVersion();
    }

    public void accept(IClazzVisitor visitor) {
        Iterator it = this.getLibraries().iterator();
        while (it.hasNext()) {
            ILibrary lib = (ILibrary)it.next();
            lib.accept(visitor);
            lib.resetTypes();
        }
    }
}

