/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.PrimaryKeyJoinColumn;
import org.eclipse.dali.orm.adapters.IPrimaryKeyJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.SingularOrPluralStringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaPrimaryKeyJoinColumnModelAdapter
implements IPrimaryKeyJoinColumnModelAdapter {
    private Member member;
    private PrimaryKeyJoinColumn primaryKeyJoinColumn;
    private Inheritance inheritance;
    private SingularOrPluralStringAnnotationElementAdapter specifiedNameAdapter;
    private SingularOrPluralStringAnnotationElementAdapter specifiedReferencedColumnNameAdapter;
    static final String PRIMARY_KEY_JOIN_COLUMN_ANNOTATION = "PrimaryKeyJoinColumn";
    static final String PRIMARY_KEY_JOIN_COLUMNS_ANNOTATION = "PrimaryKeyJoinColumns";
    static final String PRIMARY_KEY_JOIN_COLUMN_NAME_ELEMENT = "name";
    static final String PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_ELEMENT = "referencedColumnName";

    JavaPrimaryKeyJoinColumnModelAdapter(Inheritance inheritance, Member member) {
        this.inheritance = inheritance;
        this.member = member;
        this.specifiedNameAdapter = this.buildSpecifiedNameElementAdapter();
        this.specifiedReferencedColumnNameAdapter = this.buildSpecifiedReferencedColumnNameElementAdapter();
    }

    private SingularOrPluralStringAnnotationElementAdapter buildSpecifiedNameElementAdapter() {
        return new SingularOrPluralStringAnnotationElementAdapter(this.buildNameElementInfo());
    }

    private SingularOrPluralStringAnnotationElementAdapter.Info buildNameElementInfo() {
        return new SingularOrPluralStringAnnotationElementAdapter.Info(){

            public void setPersValue(String newValue) {
                JavaPrimaryKeyJoinColumnModelAdapter.this.getPrimaryKeyJoinColumn().setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaPrimaryKeyJoinColumnModelAdapter.this.getPrimaryKeyJoinColumn().getSpecifiedName();
            }

            public String annotationElementName() {
                return JavaPrimaryKeyJoinColumnModelAdapter.PRIMARY_KEY_JOIN_COLUMN_NAME_ELEMENT;
            }

            public String annotationName() {
                return JavaPrimaryKeyJoinColumnModelAdapter.PRIMARY_KEY_JOIN_COLUMN_ANNOTATION;
            }

            public String pluralAnnotationName() {
                return JavaPrimaryKeyJoinColumnModelAdapter.PRIMARY_KEY_JOIN_COLUMNS_ANNOTATION;
            }

            public Member member() {
                return JavaPrimaryKeyJoinColumnModelAdapter.this.getMember();
            }

            public String defaultValue() {
                return null;
            }

            public int persIndex() {
                return JavaPrimaryKeyJoinColumnModelAdapter.this.getPrimaryKeyJoinColumn().indexInContainer();
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private SingularOrPluralStringAnnotationElementAdapter buildSpecifiedReferencedColumnNameElementAdapter() {
        return new SingularOrPluralStringAnnotationElementAdapter(this.buildReferencedColumnNameElementInfo());
    }

    private SingularOrPluralStringAnnotationElementAdapter.Info buildReferencedColumnNameElementInfo() {
        return new SingularOrPluralStringAnnotationElementAdapter.Info(){

            public void setPersValue(String newValue) {
                JavaPrimaryKeyJoinColumnModelAdapter.this.getPrimaryKeyJoinColumn().setSpecifiedReferencedColumnName(newValue);
            }

            public String persValue() {
                return JavaPrimaryKeyJoinColumnModelAdapter.this.getPrimaryKeyJoinColumn().getSpecifiedReferencedColumnName();
            }

            public String annotationElementName() {
                return JavaPrimaryKeyJoinColumnModelAdapter.PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_ELEMENT;
            }

            public String annotationName() {
                return JavaPrimaryKeyJoinColumnModelAdapter.PRIMARY_KEY_JOIN_COLUMN_ANNOTATION;
            }

            public String pluralAnnotationName() {
                return JavaPrimaryKeyJoinColumnModelAdapter.PRIMARY_KEY_JOIN_COLUMNS_ANNOTATION;
            }

            public Member member() {
                return JavaPrimaryKeyJoinColumnModelAdapter.this.getMember();
            }

            public String defaultValue() {
                return null;
            }

            public int persIndex() {
                return JavaPrimaryKeyJoinColumnModelAdapter.this.getPrimaryKeyJoinColumn().indexInContainer();
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    public void setPrimaryKeyJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.primaryKeyJoinColumn = primaryKeyJoinColumn;
    }

    private PrimaryKeyJoinColumn getPrimaryKeyJoinColumn() {
        return this.primaryKeyJoinColumn;
    }

    private Member getMember() {
        return this.member;
    }

    public void specifiedNameChanged() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    public void specifiedReferencedColumnNameChanged() {
        this.specifiedReferencedColumnNameAdapter.updateJavaElement();
    }

    public void updatePersModel(CompilationUnit astRoot) {
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersSpecifiedName(astRoot);
        this.updatePersSpecifiedReferencedColumnName(astRoot);
        this.updatePersDefaultName();
        this.updatePersDefaultReferencedColumnName();
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.primaryKeyJoinColumn.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.primaryKeyJoinColumn.setDefaultName(name);
        }
    }

    protected String defaultName() {
        Entity entity = this.inheritance.parentEntity();
        IdMapping idMapping = entity.idMapping();
        if (idMapping == null) {
            return null;
        }
        return idMapping.getColumn().getName();
    }

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultReferencedColumnName() {
        String name = this.defaultReferencedColumnName();
        String persName = this.primaryKeyJoinColumn.getDefaultReferencedColumnName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.primaryKeyJoinColumn.setDefaultReferencedColumnName(name);
        }
    }

    protected String defaultReferencedColumnName() {
        return this.defaultName();
    }

    private void updatePersSpecifiedReferencedColumnName(CompilationUnit astRoot) {
        this.specifiedReferencedColumnNameAdapter.updatePersElement(astRoot);
    }

    public int index(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        return this.inheritance.getPrimaryKeyJoinColumns().indexOf((Object)primaryKeyJoinColumn);
    }

    public ITextRange getTextRange() {
        int index = this.primaryKeyJoinColumn.indexInContainer();
        Annotation annotation = ((JavaInheritanceModelAdapter)((Inheritance)this.getPrimaryKeyJoinColumn().getParent()).getModelAdapter()).primaryKeyJoinColumnAnnotationAt(index);
        if (annotation != null) {
            return ASTTools.textRange((ASTNode)annotation);
        }
        return null;
    }

    public ITextRange joinColumnTextRange() {
        return this.specifiedNameAdapter.textRange();
    }

    public ITextRange referencedColumnTextRange() {
        return this.specifiedReferencedColumnNameAdapter.textRange();
    }
}

