/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dali.ui.internal.selection.SelectionManager;
import org.eclipse.dali.ui.selection.ISelectionManager;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectionManagerFactory {
    private static SelectionManagerFactory INSTANCE;
    private static Object MUTEX;
    private Map managers = new HashMap();
    private WindowListener windowListener = new WindowListener();

    static {
        MUTEX = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISelectionManager getSelectionManager(IWorkbenchWindow window) {
        if (INSTANCE == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new SelectionManagerFactory();
                    INSTANCE.init();
                }
            }
        }
        return INSTANCE.internalGetSelectionManager(window);
    }

    private SelectionManagerFactory() {
    }

    private void init() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this.windowListener);
    }

    private SelectionManager internalGetSelectionManager(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(window.toString());
        }
        if (!this.managers.containsKey(window)) {
            SelectionManager manager = new SelectionManager();
            this.managers.put(window, manager);
            manager.init(window);
        }
        return (SelectionManager)this.managers.get(window);
    }

    private class WindowListener
    implements IWindowListener {
        private WindowListener() {
        }

        public void windowOpened(IWorkbenchWindow aWindow) {
        }

        public void windowClosed(IWorkbenchWindow aWindow) {
            SelectionManager manager = SelectionManagerFactory.this.internalGetSelectionManager(aWindow);
            manager.dispose();
            SelectionManagerFactory.this.managers.remove(aWindow);
        }

        public void windowActivated(IWorkbenchWindow aWindow) {
        }

        public void windowDeactivated(IWorkbenchWindow aWindow) {
        }
    }
}

