/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.internal.selection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.dali.internal.utility.iterators.CloneIterator;
import org.eclipse.dali.ui.selection.ISelectionManager;
import org.eclipse.dali.ui.selection.ISelectionParticipant;
import org.eclipse.dali.ui.selection.Selection;
import org.eclipse.dali.ui.selection.SelectionEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class SelectionManager
implements ISelectionManager {
    private Set pages = Collections.synchronizedSet(new HashSet());
    private Map selectionParticipants = Collections.synchronizedMap(new HashMap());
    private IPageListener pageListener = new PageListener();
    private IPartListener2 partListener = new PartListener();
    private IWorkbenchWindow window;
    private Selection currentSelection = Selection.NULL_SELECTION;
    static /* synthetic */ Class class$0;

    public void init(IWorkbenchWindow aWindow) {
        this.window = aWindow;
        aWindow.addPageListener(this.pageListener);
        this.initPage(aWindow.getActivePage());
    }

    private void initPage(IWorkbenchPage page) {
        if (page != null && !this.pages.contains(page)) {
            page.addPartListener(this.partListener);
            this.pages.add(page);
            IEditorPart activeEditor = page.getActiveEditor();
            this.initPart((IWorkbenchPart)activeEditor);
            this.selectPart((IWorkbenchPart)activeEditor);
        }
    }

    private void disposePage(IWorkbenchPage page) {
        if (page != null && this.pages.contains(page)) {
            page.removePartListener(this.partListener);
            this.pages.remove(page);
        }
    }

    private void initPart(IWorkbenchPart part) {
        if (part != null && this.selectionParticipants.get(part) == null) {
            ISelectionParticipant selectionParticipant;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dali.ui.selection.ISelectionParticipant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((selectionParticipant = (ISelectionParticipant)part.getAdapter((Class)clazz)) != null) {
                this.selectionParticipants.put(part, selectionParticipant);
            }
        }
    }

    private void selectPart(IWorkbenchPart part) {
        ISelectionParticipant selectionParticipant = this.getSelectionParticipant(part);
        if (selectionParticipant != null) {
            this.select(selectionParticipant.getSelection());
        }
    }

    private void hidePart(IWorkbenchPart part) {
        ISelectionParticipant selectionParticipant = this.getSelectionParticipant(part);
        if (selectionParticipant != null && selectionParticipant.disposeOnHide()) {
            this.closePart(part);
        }
    }

    private void closePart(IWorkbenchPart part) {
        ISelectionParticipant selectionParticipant = this.getSelectionParticipant(part);
        if (selectionParticipant != null) {
            this.disposePart(part);
            this.checkForNoEditors();
        }
    }

    private void disposePart(IWorkbenchPart part) {
        if (part != null && this.selectionParticipants.containsKey(part)) {
            ISelectionParticipant selectionParticipant = (ISelectionParticipant)this.selectionParticipants.remove(part);
            selectionParticipant.dispose();
        }
    }

    private void checkForNoEditors() {
        IWorkbenchPage activePage = this.window.getActivePage();
        if (activePage == null || activePage.getActiveEditor() == null) {
            this.select(Selection.NULL_SELECTION);
        }
    }

    public void register(IWorkbenchPart part) {
        this.initPart(part);
    }

    public void select(Selection newSelection) {
        if (this.currentSelection.equals(newSelection)) {
            return;
        }
        this.currentSelection = newSelection;
        this.fireSelectionChange(new SelectionEvent(newSelection, SelectionEvent.SELECTION, this));
    }

    public void deselect(Selection oldSelection) {
        if (this.currentSelection.equals(oldSelection)) {
            this.currentSelection = Selection.NULL_SELECTION;
            this.fireSelectionChange(new SelectionEvent(oldSelection, SelectionEvent.DESELECTION, this));
        }
    }

    private void fireSelectionChange(SelectionEvent event) {
        Iterator stream = this.selectionParticipants.values().iterator();
        while (stream.hasNext()) {
            ((ISelectionParticipant)stream.next()).selectionChanged(event);
        }
    }

    private ISelectionParticipant getSelectionParticipant(IWorkbenchPart part) {
        return (ISelectionParticipant)this.selectionParticipants.get(part);
    }

    public Selection getCurrentSelection() {
        return this.currentSelection;
    }

    public void dispose() {
        this.window.removePageListener(this.pageListener);
        this.selectionParticipants.clear();
        CloneIterator stream = new CloneIterator((Collection)this.pages);
        while (stream.hasNext()) {
            this.disposePage((IWorkbenchPage)stream.next());
        }
        stream = new CloneIterator(this.selectionParticipants.keySet());
        while (stream.hasNext()) {
            this.disposePart((IWorkbenchPart)stream.next());
        }
    }

    private class PageListener
    implements IPageListener {
        private PageListener() {
        }

        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
            SelectionManager.this.disposePage(page);
        }

        public void pageOpened(IWorkbenchPage page) {
            SelectionManager.this.initPage(page);
        }
    }

    private class PartListener
    implements IPartListener2 {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.initPart(part);
                SelectionManager.this.selectPart(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.closePart(part);
                SelectionManager.this.disposePart(part);
                SelectionManager.this.checkForNoEditors();
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.hidePart(part);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.initPart(part);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                SelectionManager.this.initPart(part);
            }
        }
    }
}

