/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.dali.core.internal.PersistenceBuilder;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.internal.utility.iterators.CompositeIterator;
import org.eclipse.dali.internal.utility.iterators.FilteringIterator;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.internal.utility.iterators.TreeIterator;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceContainer;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.impl.PersistenceContainerImpl;
import org.eclipse.dali.orm.impl.PersistenceModelManager;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;

public class PersistenceProjectImpl
extends PersistenceContainerImpl
implements PersistenceProject {
    public static final String VALIDATION_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    public static String CONNECTION_INFO_PROPERTY = "connectionInfoProperty";
    public static String SCHEMA_PROPERTY = "schemaProperty";
    private IJavaProject javaProject;
    boolean constructed = false;

    public static void addNatureToProject(IJavaProject javaProject) throws CoreException {
        if (!javaProject.getProject().isOpen()) {
            return;
        }
        if (PersistenceProjectImpl.containsNature(javaProject)) {
            return;
        }
        IProject project = javaProject.getProject();
        IProjectDescription description = project.getDescription();
        String[] oldNatureIds = description.getNatureIds();
        String[] newNatureIds = new String[oldNatureIds.length + 1];
        System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
        newNatureIds[oldNatureIds.length] = "org.eclipse.dali.core.persistenceNature";
        description.setNatureIds(newNatureIds);
        project.setDescription(description, null);
    }

    public static void addNatureToProject(IJavaProject javaProject, String connectionInfoName, String schemaName) throws CoreException {
        PersistenceProjectImpl.addNatureToProject(javaProject);
        PersistenceProjectImpl.setConnectionInfoAndSchemaNameForWizard(javaProject.getProject(), connectionInfoName, schemaName);
    }

    public static boolean containsNature(IJavaProject javaProject) {
        IProjectNature nature;
        try {
            nature = javaProject.getProject().getNature("org.eclipse.dali.core.persistenceNature");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return nature != null;
    }

    public static PersistenceProjectImpl getPersistenceProject(IProject project) {
        try {
            PersistenceProjectImpl nature = (PersistenceProjectImpl)project.getNature("org.eclipse.dali.core.persistenceNature");
            return nature;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public PersistenceProjectImpl() {
        super(null);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.PERSISTENCE_PROJECT;
    }

    public void configure() throws CoreException {
        PersistenceBuilder.addBuilderToProject(this.getProject());
        ProjectUtilities.addToBuildSpec((String)VALIDATION_BUILDER_ID, (IProject)this.getProject());
    }

    public void deconfigure() throws CoreException {
        ProjectUtilities.removeFromBuildSpec((String)VALIDATION_BUILDER_ID, (IProject)this.getProject());
        PersistenceBuilder.removeBuilderFromProject(this.getProject());
        PersistenceBuilder.deleteAuditMarkers(this.getProject());
    }

    public IProject getProject() {
        return (IProject)this.resource;
    }

    public void setProject(IProject project) {
        this.resource = project;
        this.javaProject = JavaCore.create((IProject)project);
        PersistenceModelManager.getPersistenceModelManager().getPersistenceModel().getProjects().add((Object)this);
    }

    public void buildResources() {
        this.buildInternalResources();
        this.setConstructed(true);
    }

    synchronized void setConstructed(boolean constructed) {
        this.constructed = constructed;
    }

    public synchronized boolean isConstructed() {
        return this.constructed;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public Iterator persistenceFiles() {
        return new FilteringIterator((Iterator)new TreeIterator((Object)this, new TreeIterator.Midwife(){

            public Iterator children(Object next) {
                if (next instanceof PersistenceContainer) {
                    return ((PersistenceContainer)next).getPersistenceResources().iterator();
                }
                return NullIterator.instance();
            }
        })){

            protected boolean accept(Object o) {
                return o instanceof PersistenceFile;
            }
        };
    }

    public Iterator mappedTypes() {
        return new FilteringIterator((Iterator)new CompositeIterator((Iterator)new TransformationIterator(this.persistenceFiles()){

            protected Object transform(Object next) {
                return ((PersistenceFile)next).getPersistentTypes().iterator();
            }
        })){

            protected boolean accept(Object o) {
                return ((PersistentType)o).getTypeMapping().isMapped();
            }
        };
    }

    public String getConnectionName() {
        try {
            return this.getProject().getPersistentProperty(new QualifiedName("org.eclipse.dali.core", CONNECTION_INFO_PROPERTY));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void setConnectionName(String connectionInfoName) {
        try {
            this.getProject().setPersistentProperty(new QualifiedName("org.eclipse.dali.core", CONNECTION_INFO_PROPERTY), connectionInfoName);
        }
        catch (CoreException e) {
            System.out.println("No such Project");
            throw new RuntimeException(e.getMessage());
        }
    }

    public Connection getConnection() {
        return PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNamed(this.getConnectionName());
    }

    public String getSchemaName() {
        try {
            return this.getProject().getPersistentProperty(new QualifiedName("org.eclipse.dali.core", SCHEMA_PROPERTY));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void setSchemaName(String schemaName) {
        try {
            this.getProject().setPersistentProperty(new QualifiedName("org.eclipse.dali.core", SCHEMA_PROPERTY), schemaName);
        }
        catch (CoreException e) {
            System.out.println("No such Project");
            throw new RuntimeException(e.getMessage());
        }
    }

    public Schema getSchema() {
        return this.getConnection().getDatabase().schemaNamed(this.getSchemaName());
    }

    public static void setConnectionInfoAndSchemaNameForWizard(IProject project, String connectionInfoName, String schemaName) {
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.dali.core", CONNECTION_INFO_PROPERTY), connectionInfoName);
            project.setPersistentProperty(new QualifiedName("org.eclipse.dali.core", SCHEMA_PROPERTY), schemaName);
        }
        catch (CoreException e) {
            System.out.println("No such Project");
            throw new RuntimeException(e.getMessage());
        }
    }
}

