/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.Temporal;
import org.eclipse.dali.orm.TemporalType;
import org.eclipse.dali.orm.adapters.ITemporalModelAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaTemporalModelAdapter
implements ITemporalModelAdapter {
    Temporal temporal;
    private EnumAnnotationElementAdapter temporalTypeAdapter;
    private static final String ANNOTATION_NAME = "Temporal";
    static final String TEMPORAL_TYPE_DATE_NAME = "DATE";
    static final String TEMPORAL_TYPE_TIME_NAME = "TIME";
    static final String TEMPORAL_TYPE_TIMESTAMP_NAME = "TIMESTAMP";

    public JavaTemporalModelAdapter(String temporalTypeName) {
        this.temporal = OrmFactory.eINSTANCE.createTemporal(this, this.temporalTypeNamed(temporalTypeName));
        this.temporalTypeAdapter = new TemporalTypeAdapter(new TemporalTypeInfo());
    }

    private TemporalType temporalTypeNamed(String temporalTypeName) {
        if (temporalTypeName == null) {
            return TemporalType.NULL_LITERAL;
        }
        if (temporalTypeName.equals(TEMPORAL_TYPE_DATE_NAME)) {
            return TemporalType.DATE_LITERAL;
        }
        if (temporalTypeName.equals(TEMPORAL_TYPE_TIME_NAME)) {
            return TemporalType.TIME_LITERAL;
        }
        if (temporalTypeName.equals(TEMPORAL_TYPE_TIMESTAMP_NAME)) {
            return TemporalType.TIMESTAMP_LITERAL;
        }
        return TemporalType.NULL_LITERAL;
    }

    public Temporal getTemporal() {
        return this.temporal;
    }

    public ITextRange getTextRange() {
        return this.member().getTextRange(ANNOTATION_NAME);
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.temporalTypeAdapter.updatePersElement(astRoot);
    }

    public void temporalTypeChanged() {
        this.temporalTypeAdapter.updateJavaElement();
    }

    Member member() {
        return ((JavaPersistentAttributeModelAdapter)this.attributeMapping().getPersistentAttribute().getModelAdapter()).getAttribute();
    }

    private AttributeMapping attributeMapping() {
        return (AttributeMapping)this.temporal.eContainer();
    }

    private class TemporalTypeAdapter
    extends EnumAnnotationElementAdapter {
        TemporalTypeAdapter(TemporalTypeInfo info) {
            super(info);
        }

        public boolean updateJavaElement() {
            CompilationUnit astRoot = this.getInfo().member().createASTRoot();
            String javaValue = this.javaValue(astRoot);
            TemporalType tt = this.getTemporalTypeInfo().temporalTypeFor(javaValue);
            javaValue = this.getTemporalTypeInfo().persValueFor(tt);
            String persValue = this.getInfo().persValue();
            if (persValue == null && javaValue == null) {
                return false;
            }
            if (persValue == null || !persValue.equals(javaValue)) {
                this.setJavaValue(persValue);
                return true;
            }
            return false;
        }

        private TemporalTypeInfo getTemporalTypeInfo() {
            return (TemporalTypeInfo)this.getInfo();
        }
    }

    private class TemporalTypeInfo
    implements EnumAnnotationElementAdapter.EnumAnnotationElementInfo {
        private TemporalTypeInfo() {
        }

        public void setPersValue(String javaString) {
            TemporalType tt = this.temporalTypeFor(javaString);
            if (tt != this.temporal().getType()) {
                this.temporal().setType(tt);
            }
        }

        TemporalType temporalTypeFor(String javaString) {
            if (javaString == null) {
                return TemporalType.NULL_LITERAL;
            }
            if (javaString.equals(JavaTemporalModelAdapter.TEMPORAL_TYPE_DATE_NAME)) {
                return TemporalType.DATE_LITERAL;
            }
            if (javaString.equals(JavaTemporalModelAdapter.TEMPORAL_TYPE_TIME_NAME)) {
                return TemporalType.TIME_LITERAL;
            }
            if (javaString.equals(JavaTemporalModelAdapter.TEMPORAL_TYPE_TIMESTAMP_NAME)) {
                return TemporalType.TIMESTAMP_LITERAL;
            }
            return TemporalType.NULL_LITERAL;
        }

        public String persValue() {
            return this.persValueFor(this.temporal().getType());
        }

        String persValueFor(TemporalType temporalType) {
            if (temporalType == TemporalType.DATE_LITERAL) {
                return JavaTemporalModelAdapter.TEMPORAL_TYPE_DATE_NAME;
            }
            if (temporalType == TemporalType.TIME_LITERAL) {
                return JavaTemporalModelAdapter.TEMPORAL_TYPE_TIME_NAME;
            }
            if (temporalType == TemporalType.TIMESTAMP_LITERAL) {
                return JavaTemporalModelAdapter.TEMPORAL_TYPE_TIMESTAMP_NAME;
            }
            if (temporalType == TemporalType.NULL_LITERAL) {
                return null;
            }
            throw new IllegalStateException("Unrecognized TemporalType: " + (Object)((Object)temporalType));
        }

        public String annotationElementName() {
            return "value";
        }

        public String annotationName() {
            return JavaTemporalModelAdapter.ANNOTATION_NAME;
        }

        public Member member() {
            return JavaTemporalModelAdapter.this.member();
        }

        public String defaultValue() {
            return null;
        }

        public boolean removeAnnotationIfEmpty() {
            return false;
        }

        public String enumClassName() {
            return "TemporalType";
        }

        private Temporal temporal() {
            return JavaTemporalModelAdapter.this.temporal;
        }
    }
}

