/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.impl.SingleTableInheritanceChildTableImpl;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.TableItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TableComposite
extends Composite
implements IPersistenceComposite {
    private Table table;
    private TableItemProvider tableItemProvider;
    private INotifyChangedListener tableListener;
    protected EditingDomain editingDomain;
    protected Combo tableCombo;
    protected boolean populating;
    static /* synthetic */ Class class$0;

    public TableComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.tableItemProvider = (TableItemProvider)adapterFactory.createTableAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Label tableLabel = new Label((Composite)this, 16384);
        tableLabel.setText(DaliUiMessages.TableComposite_name);
        this.tableCombo = this.buildTableCombo(this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tableCombo, "org.eclipse.dali.ui.entity_table");
    }

    private Combo buildTableCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add(DaliUiMessages.TableComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableComposite.this.populating) {
                    return;
                }
                String tableText = ((Combo)e.getSource()).getText();
                if (tableText.equals("")) {
                    tableText = null;
                    if (TableComposite.this.table.getSpecifiedName() == null || TableComposite.this.table.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (tableText != null && combo.getItemCount() > 0 && tableText.equals(combo.getItem(0))) {
                    tableText = null;
                }
                if (TableComposite.this.table.getSpecifiedName() == null || !TableComposite.this.table.getSpecifiedName().equals(tableText)) {
                    TableComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TableComposite.this.editingDomain, (Object)TableComposite.this.table, (Object)OrmPackage.eINSTANCE.getTable_SpecifiedName(), (Object)tableText));
                }
            }
        });
        return combo;
    }

    private INotifyChangedListener getTableListener() {
        if (this.tableListener == null) {
            this.tableListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    TableComposite.this.tableChanged(notification);
                }
            };
        }
        return this.tableListener;
    }

    protected void tableChanged(Notification notification) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 1) {
            final String tableName = this.table.getSpecifiedName();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (TableComposite.this.tableCombo.getText() == null || !TableComposite.this.tableCombo.getText().equals(tableName)) {
                        if (tableName == null) {
                            TableComposite.this.tableCombo.select(0);
                        } else {
                            TableComposite.this.tableCombo.setText(tableName);
                        }
                    }
                }
            });
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.Table");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 0) {
                final String defaultTableName = this.table.getDefaultName();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        int selectionIndex = TableComposite.this.tableCombo.getSelectionIndex();
                        TableComposite.this.tableCombo.setItem(0, NLS.bind((String)DaliUiMessages.TableComposite_defaultWithOneParam, (Object)defaultTableName));
                        if (selectionIndex == 0) {
                            TableComposite.this.tableCombo.select(0);
                        }
                    }
                });
            }
        }
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.table != null) {
            this.tableItemProvider.removeListener(this.getTableListener());
            this.table.eAdapters().remove((Object)this.tableItemProvider);
        }
        this.table = (Table)model;
        if (this.table == null) {
            return;
        }
        this.tableItemProvider.addListener(this.getTableListener());
        this.table.eAdapters().add((Object)this.tableItemProvider);
        this.populateTableCombo();
        this.populating = false;
    }

    private void populateTableCombo() {
        String tableName = this.table.getSpecifiedName();
        String defaultTableName = this.table.getDefaultName();
        this.tableCombo.setEnabled(!(this.table instanceof SingleTableInheritanceChildTableImpl));
        this.tableCombo.setItem(0, NLS.bind((String)DaliUiMessages.TableComposite_defaultWithOneParam, (Object)defaultTableName));
        PersistenceProject persistenceProject = this.table.getPersistenceProject();
        Connection connection = persistenceProject.getConnection();
        if (connection.isConnected()) {
            this.tableCombo.remove(1, this.tableCombo.getItemCount() - 1);
            Iterator tables = connection.getDatabase().schemaNamed(persistenceProject.getSchemaName()).tableNames();
            Iterator stream = CollectionTools.sort((Iterator)tables);
            while (stream.hasNext()) {
                this.tableCombo.add((String)stream.next());
            }
        } else {
            this.tableCombo.remove(1, this.tableCombo.getItemCount() - 1);
        }
        if (tableName != null) {
            if (!this.tableCombo.getText().equals(tableName)) {
                this.tableCombo.setText(tableName);
            }
        } else if (!this.tableCombo.getText().equals(NLS.bind((String)DaliUiMessages.TableComposite_defaultWithOneParam, (Object)defaultTableName))) {
            this.tableCombo.select(0);
        }
    }

    public void dispose() {
        if (this.table != null) {
            this.table.eAdapters().remove((Object)this.tableItemProvider);
        }
        super.dispose();
    }
}

