/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.validation;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pair;

public class PropertyConstraintMappingValidation {
    private String errorMsg = "Constraint cannot apply on this property's datatype";
    private final String[] intervalArr = new String[]{"MAX", "MIN", "SCALING", "DEFAULT"};
    private final String[] boolArr = new String[]{"DEFAULT"};
    private final String[] strArr = new String[]{"STRLEN", "REGEX", "DEFAULT"};
    private final String[] mimeArr = new String[]{"MIMETYPE"};
    private final String[] byteArr = (String[])Conversions.unwrapArray((Object)Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)this.intervalArr)), (Iterable)((Iterable)Conversions.doWrapArray((Object)this.mimeArr))), String.class);
    private final HashMap<String, String[]> valueTypeMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"int", (Object)this.intervalArr), Pair.of((Object)"byte", (Object)this.byteArr), Pair.of((Object)"float", (Object)this.intervalArr), Pair.of((Object)"long", (Object)this.intervalArr), Pair.of((Object)"short", (Object)this.intervalArr), Pair.of((Object)"double", (Object)this.intervalArr), Pair.of((Object)"dateTime", (Object)this.intervalArr), Pair.of((Object)"string", (Object)this.strArr), Pair.of((Object)"boolean", (Object)this.boolArr), Pair.of((Object)"base64Binary", (Object)this.mimeArr)});

    public final boolean checkPropertyConstraints(PrimitiveType type, Constraint cons) {
        String[] arr = this.valueTypeMap.get(type.getLiteral());
        boolean _equals = cons.getType().getLiteral().toUpperCase().equals("NULLABLE");
        if (_equals) {
            return true;
        }
        if (arr == null || !((List)Conversions.doWrapArray((Object)arr)).contains(cons.getType().getLiteral())) {
            this.setErrorMessage("Constraint cannot apply on this property's datatype");
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    private String setErrorMessage(String err) {
        this.errorMsg = err;
        return this.errorMsg;
    }
}

