/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.tomcat;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.naming.ContextAccessController;
import org.apache.tomcat.InstanceManager;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.servlet.WebBeansConfigurationListener;
import org.apache.webbeans.web.tomcat.TomcatInstanceManager;
import org.apache.webbeans.web.tomcat.TomcatSecurityListener;
import org.apache.webbeans.web.tomcat.TomcatUtil;

public class ContextLifecycleListener
implements PropertyChangeListener,
LifecycleListener,
ContainerListener,
ServletContextAttributeListener {
    private StandardServer standardServer;

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            if (event.getSource() instanceof StandardServer) {
                if (event.getType().equals("start")) {
                    this.standardServer = (StandardServer)event.getSource();
                    this.start();
                }
            } else if (event.getSource() instanceof StandardContext) {
                ServletContext scontext;
                URL url;
                StandardContext context = (StandardContext)event.getSource();
                if (event.getType().equals("configure_start") && (url = this.getBeansXml(scontext = context.getServletContext())) != null) {
                    System.setProperty("org.apache.webbeans.application.jsp", "true");
                    String[] oldListeners = context.findApplicationListeners();
                    LinkedList<String> listeners = new LinkedList<String>();
                    listeners.addFirst(WebBeansConfigurationListener.class.getName());
                    for (String listener : oldListeners) {
                        listeners.add(listener);
                        context.removeApplicationListener(listener);
                    }
                    for (String listener : listeners) {
                        context.addApplicationListener(listener);
                    }
                    context.addApplicationListener(TomcatSecurityListener.class.getName());
                    context.addApplicationEventListener((Object)this);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URL getBeansXml(ServletContext scontext) throws MalformedURLException {
        URL url = scontext.getResource("/WEB-INF/beans.xml");
        if (url == null) {
            url = scontext.getResource("/WEB-INF/classes/META-INF/beans.xml");
        }
        return url;
    }

    public void containerEvent(ContainerEvent event) {
        try {
            if (event.getSource() instanceof StandardContext) {
                Object listener;
                StandardContext context = (StandardContext)event.getSource();
                if (event.getType().equals("beforeContextInitialized")) {
                    ClassLoader loader = context.getLoader().getClassLoader();
                    Object listener2 = event.getData();
                    if (listener2.getClass().getName().equals(WebBeansConfigurationListener.class.getName())) {
                        ContextAccessController.setWritable((Object)context.getNamingContextListener().getName(), (Object)context);
                        return;
                    }
                    URL url = this.getBeansXml(context.getServletContext());
                    if (url != null) {
                        TomcatUtil.inject(listener2, loader);
                    }
                } else if (event.getType().equals("afterContextInitialized")) {
                    ClassLoader loader = context.getLoader().getClassLoader();
                    Object listener3 = event.getData();
                    if (listener3.getClass().getName().equals(WebBeansConfigurationListener.class.getName())) {
                        this.setInstanceManager(context);
                        ContextAccessController.setReadOnly((Object)context.getNamingContextListener().getName());
                        URL url = this.getBeansXml(context.getServletContext());
                        if (url != null) {
                            Object[] listeners;
                            for (Object instance : listeners = context.getApplicationEventListeners()) {
                                if (instance.getClass().getName().equals(WebBeansConfigurationListener.class.getName())) continue;
                                TomcatUtil.inject(instance, loader);
                            }
                        }
                    }
                } else if (event.getType().equals("beforeContextDestroyed") && (listener = event.getData()).getClass().getName().equals(WebBeansConfigurationListener.class.getName())) {
                    ContextAccessController.setWritable((Object)context.getNamingContextListener().getName(), (Object)context);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setInstanceManager(StandardContext context) {
        if (context.getInstanceManager() instanceof TomcatInstanceManager) {
            return;
        }
        InstanceManager processor = context.getInstanceManager();
        TomcatInstanceManager custom = new TomcatInstanceManager(context.getLoader().getClassLoader(), processor);
        context.setInstanceManager((InstanceManager)custom);
        context.getServletContext().setAttribute(InstanceManager.class.getName(), (Object)custom);
    }

    public void start() {
        this.standardServer.addPropertyChangeListener((PropertyChangeListener)this);
        this.standardServer.addLifecycleListener((LifecycleListener)this);
        for (Service service : this.standardServer.findServices()) {
            this.serviceAdded(service);
        }
    }

    public void stop() {
        this.standardServer.removePropertyChangeListener((PropertyChangeListener)this);
    }

    private void serviceAdded(Service service) {
        Container container = service.getContainer();
        if (container instanceof StandardEngine) {
            StandardEngine engine = (StandardEngine)container;
            this.engineAdded(engine);
        }
    }

    private void engineAdded(StandardEngine engine) {
        this.addContextListener((ContainerBase)engine);
        for (Container child : engine.findChildren()) {
            if (!(child instanceof StandardHost)) continue;
            StandardHost host = (StandardHost)child;
            this.hostAdded(host);
        }
    }

    private void hostAdded(StandardHost host) {
        this.addContextListener((ContainerBase)host);
        host.addLifecycleListener((LifecycleListener)this);
        for (Container child : host.findChildren()) {
            if (!(child instanceof StandardContext)) continue;
            StandardContext context = (StandardContext)child;
            this.contextAdded(context);
        }
    }

    private void contextAdded(StandardContext context) {
        this.forceFirstLifecycleListener(context);
    }

    private void forceFirstLifecycleListener(StandardContext context) {
        LifecycleListener[] listeners = context.findLifecycleListeners();
        if (listeners.length > 0 && listeners[0] == this) {
            return;
        }
        for (LifecycleListener listener : listeners) {
            context.removeLifecycleListener(listener);
        }
        context.addLifecycleListener((LifecycleListener)this);
        context.addContainerListener((ContainerListener)this);
        for (LifecycleListener listener : listeners) {
            if (listener == this) continue;
            context.addLifecycleListener(listener);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("service".equals(event.getPropertyName())) {
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (oldValue == null && newValue instanceof Service) {
                this.serviceAdded((Service)newValue);
            }
        }
        if ("children".equals(event.getPropertyName())) {
            Object source = event.getSource();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (source instanceof StandardEngine && oldValue == null && newValue instanceof StandardHost) {
                this.hostAdded((StandardHost)newValue);
            }
            if (source instanceof StandardHost && oldValue == null && newValue instanceof StandardContext) {
                this.contextAdded((StandardContext)newValue);
            }
        }
    }

    private void addContextListener(ContainerBase containerBase) {
        try {
            Field field = (Field)AccessController.doPrivileged(new PrivilegedActionForClass(ContainerBase.class, "children"));
            AccessController.doPrivileged(new PrivilegedActionForAccessibleObject(field, true));
            Map children = (Map)field.get(containerBase);
            if (children instanceof MoniterableHashMap) {
                return;
            }
            children = new MoniterableHashMap(children, containerBase, "children", this);
            field.set(containerBase, children);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (InstanceManager.class.getName().equals(servletContextAttributeEvent.getName())) {
            try {
                StandardContext context = (StandardContext)ContextLifecycleListener.getContext(ContextLifecycleListener.getContext(servletContextAttributeEvent.getServletContext()));
                this.setInstanceManager(context);
            }
            catch (NoSuchFieldException e) {
                throw new WebBeansException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new WebBeansException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getContext(Object o) throws NoSuchFieldException, IllegalAccessException {
        Field getContext = o.getClass().getDeclaredField("context");
        boolean acc = getContext.isAccessible();
        getContext.setAccessible(true);
        try {
            Object object = getContext.get(o);
            return object;
        }
        finally {
            getContext.setAccessible(acc);
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoniterableHashMap
    extends HashMap<Object, Object> {
        private static final long serialVersionUID = 1L;
        private final Object source;
        private final String propertyName;
        private final PropertyChangeListener listener;

        public MoniterableHashMap(Map<Object, Object> m, Object source, String propertyName, PropertyChangeListener listener) {
            super(m);
            this.source = source;
            this.propertyName = propertyName;
            this.listener = listener;
        }

        @Override
        public Object put(Object key, Object value) {
            Object oldValue = super.put(key, value);
            PropertyChangeEvent event = new PropertyChangeEvent(this.source, this.propertyName, null, value);
            this.listener.propertyChange(event);
            return oldValue;
        }

        @Override
        public Object remove(Object key) {
            Object value = super.remove(key);
            PropertyChangeEvent event = new PropertyChangeEvent(this.source, this.propertyName, value, null);
            this.listener.propertyChange(event);
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionForAccessibleObject
    implements PrivilegedAction<Object> {
        AccessibleObject object;
        boolean flag;

        protected PrivilegedActionForAccessibleObject(AccessibleObject object, boolean flag) {
            this.object = object;
            this.flag = flag;
        }

        @Override
        public Object run() {
            this.object.setAccessible(this.flag);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionForClass
    implements PrivilegedAction<Object> {
        Class<?> clazz;
        Object parameters;

        protected PrivilegedActionForClass(Class<?> clazz, Object parameters) {
            this.clazz = clazz;
            this.parameters = parameters;
        }

        @Override
        public Object run() {
            try {
                return this.clazz.getDeclaredField((String)this.parameters);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

