/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.scripting.groovy;

import com.sun.faces.util.Util;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroovyHelper {
    private static final Logger LOGGER = Logger.getLogger(GroovyHelper.class.getPackage().getName());

    public static boolean isGroovyAvailable(FacesContext ctx) {
        return ctx.getExternalContext().getApplicationMap().get("com.sun.faces.groovyhelper") != null;
    }

    public static GroovyHelper getCurrentInstance(FacesContext ctx) {
        return (GroovyHelper)ctx.getExternalContext().getApplicationMap().get("com.sun.faces.groovyhelper");
    }

    public static GroovyHelper getCurrentInstance(ServletContext sc) {
        return (GroovyHelper)sc.getAttribute("com.sun.faces.groovyhelper");
    }

    public static GroovyHelper getCurrentInstance() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            return GroovyHelper.getCurrentInstance(ctx);
        }
        return null;
    }

    public abstract Class<?> loadScript(String var1);

    public static Object newInstance(String name, Class<?> type, Object root) throws Exception {
        Class delegate = Util.loadClass(name, GroovyHelper.class);
        try {
            Constructor decorationCtor = GroovyHelper.requiresDecoration(delegate, type, root);
            if (decorationCtor != null) {
                return decorationCtor.newInstance(root);
            }
            return delegate.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static Object newInstance(String name) throws Exception {
        return GroovyHelper.newInstance(name, null, null);
    }

    public abstract void setClassLoader();

    public abstract void addURL(URL var1);

    private static Constructor requiresDecoration(Class<?> groovyClass, Class<?> ctorArgument, Object root) {
        block3: {
            if (root != null) {
                try {
                    return groovyClass.getConstructor(ctorArgument);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block3;
                    LOGGER.log(Level.FINEST, "Unable to get constructor", e);
                }
            }
        }
        return null;
    }
}

