/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.fs.internal;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;

final class JarFileArtifactFSEntry
implements ArtifactFSEntry {
    private final File file;
    private final String entryName;

    JarFileArtifactFSEntry(File file, String entryName) {
        this.file = file;
        this.entryName = entryName;
    }

    @Override
    public String getPath() {
        return this.entryName;
    }

    @Override
    public String getName() {
        String filePath = this.removeTrailingSlash();
        int lastDir = filePath.lastIndexOf("/");
        return filePath.substring(lastDir + 1);
    }

    private String removeTrailingSlash() {
        return this.entryName.endsWith("/") ? this.entryName.substring(0, this.entryName.length() - 1) : this.entryName;
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException("This ArtifactFSEntry is a member of a JAR file. Deleting it is unsupported");
    }

    @Override
    public boolean isDirectory() {
        ZipEntry zipEntry = this.findZipEntry();
        if (zipEntry != null) {
            return zipEntry.isDirectory();
        }
        return this.hasChildren();
    }

    private ZipEntry findZipEntry() {
        JarFileScanner scanner = new JarFileScanner();
        try {
            ZipEntry entry = scanner.getNextEntry();
            while (entry != null) {
                if (this.entryName.equals(entry.getName())) {
                    ZipEntry zipEntry = entry;
                    return zipEntry;
                }
                entry = scanner.getNextEntry();
            }
            return null;
        }
        finally {
            scanner.close();
        }
    }

    private boolean hasChildren() {
        boolean hasChildren = false;
        if (this.entryName.endsWith("/")) {
            JarFileScanner scanner = new JarFileScanner();
            try {
                ZipEntry entry = scanner.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name != null && name.startsWith(this.entryName)) {
                        hasChildren = true;
                        break;
                    }
                    entry = scanner.getNextEntry();
                }
            }
            finally {
                scanner.close();
            }
        }
        return hasChildren;
    }

    @Override
    public InputStream getInputStream() {
        JarFileScanner scanner = new JarFileScanner();
        ZipEntry entry = scanner.getNextEntry();
        while (entry != null && !this.entryName.equals(entry.getName())) {
            entry = scanner.getNextEntry();
        }
        if (entry == null) {
            scanner.close();
            throw new UnsupportedOperationException("Cannot open an input stream for a non-existent entry");
        }
        if (entry.isDirectory()) {
            scanner.close();
            throw new UnsupportedOperationException("Cannot open an input stream for a directory");
        }
        return scanner.getZipInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("This ArtifactFSEntry is a member of a JAR file. Writing it is unsupported");
    }

    @Override
    public ArtifactFSEntry[] getChildren() {
        if (!this.isDirectory()) {
            throw new UnsupportedOperationException("Cannot get children of a non-directory entry");
        }
        HashSet<ArtifactFSEntry> children = new HashSet<ArtifactFSEntry>();
        if (this.exists()) {
            JarFileScanner scanner = new JarFileScanner();
            try {
                ZipEntry entry = scanner.getNextEntry();
                while (entry != null) {
                    String childEntry = entry.getName();
                    if (childEntry.length() > this.entryName.length() && childEntry.startsWith(this.entryName)) {
                        children.add(this.createChildEntry(childEntry));
                        this.addParentDirectories(childEntry, children);
                    }
                    entry = scanner.getNextEntry();
                }
            }
            finally {
                scanner.close();
            }
        }
        return children.toArray(new ArtifactFSEntry[children.size()]);
    }

    public JarFileArtifactFSEntry createChildEntry(String childEntryName) {
        return new JarFileArtifactFSEntry(this.file, childEntryName);
    }

    private void addParentDirectories(String childEntry, Set<ArtifactFSEntry> children) {
        int l = this.entryName.length();
        String childPath = childEntry.substring(l);
        String[] childPathComponents = childPath.split("/");
        String parentPath = this.entryName;
        int parent = 0;
        while (parent < childPathComponents.length - 1) {
            parentPath = String.valueOf(parentPath) + childPathComponents[parent] + "/";
            children.add(this.createChildEntry(parentPath));
            ++parent;
        }
    }

    @Override
    public ArtifactFS getArtifactFS() {
        throw new UnsupportedOperationException("getArtifactFS method not supported by JarFileArtifactFSEntry");
    }

    @Override
    public boolean exists() {
        if (this.findZipEntry() != null) {
            return true;
        }
        return this.hasChildren();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.entryName == null ? 0 : this.entryName.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JarFileArtifactFSEntry)) {
            return false;
        }
        JarFileArtifactFSEntry other = (JarFileArtifactFSEntry)obj;
        if (this.entryName == null ? other.entryName != null : !this.entryName.equals(other.entryName)) {
            return false;
        }
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    private class JarFileScanner
    implements Closeable {
        private final ZipInputStream zipInputStream;

        public JarFileScanner() {
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(JarFileArtifactFSEntry.this.file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
            this.zipInputStream = is == null ? null : new ZipInputStream(is);
        }

        public ZipEntry getNextEntry() {
            if (this.zipInputStream != null) {
                try {
                    return this.zipInputStream.getNextEntry();
                }
                catch (IOException iOException) {}
            }
            return null;
        }

        public ZipInputStream getZipInputStream() {
            return this.zipInputStream;
        }

        @Override
        public void close() {
            if (this.zipInputStream != null) {
                try {
                    this.zipInputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

