/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.contributors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.virgo.bundlor.support.ManifestReader;
import org.eclipse.virgo.bundlor.support.PartialManifestModifier;
import org.eclipse.virgo.bundlor.support.TemplateHeaderReader;
import org.eclipse.virgo.bundlor.support.partialmanifest.ReadablePartialManifest;
import org.eclipse.virgo.bundlor.util.MatchUtils;
import org.eclipse.virgo.bundlor.util.SimpleParserLogger;
import org.eclipse.virgo.bundlor.util.StringUtils;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParserFactory;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public final class ExcludedImportAndExportPartialManifestModifier
implements ManifestReader,
PartialManifestModifier,
TemplateHeaderReader {
    private static final String ATTR_EXCLUDED_EXPORTS = "Excluded-Exports";
    private static final String ATTR_EXCLUDED_IMPORTS = "Excluded-Imports";
    private final List<String> excludedImports = new ArrayList<String>();
    private final Object excludedImportsMonitor = new Object();
    private final List<String> excludedExports = new ArrayList<String>();
    private final Object excludedExportsMonitor = new Object();

    @Override
    public void readJarManifest(ManifestContents manifest) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readManifestTemplate(ManifestContents manifestTemplate) {
        List<HeaderDeclaration> headers;
        String value;
        Object object = this.excludedImportsMonitor;
        synchronized (object) {
            value = (String)manifestTemplate.getMainAttributes().get(ATTR_EXCLUDED_IMPORTS);
            headers = this.parseTemplate(value);
            for (HeaderDeclaration header : headers) {
                this.excludedImports.add((String)header.getNames().get(0));
            }
        }
        object = this.excludedExportsMonitor;
        synchronized (object) {
            value = (String)manifestTemplate.getMainAttributes().get(ATTR_EXCLUDED_EXPORTS);
            headers = this.parseTemplate(value);
            for (HeaderDeclaration header : headers) {
                this.excludedExports.add((String)header.getNames().get(0));
            }
        }
    }

    private List<HeaderDeclaration> parseTemplate(String template) {
        if (StringUtils.hasText(template)) {
            HeaderParser parser = HeaderParserFactory.newHeaderParser((ParserLogger)new SimpleParserLogger());
            return parser.parseHeader(template);
        }
        return new ArrayList<HeaderDeclaration>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ReadablePartialManifest partialManifest) {
        Object object = this.excludedImportsMonitor;
        synchronized (object) {
            this.removeExcludedPackages(partialManifest.getImportedPackages(), this.excludedImports);
        }
        object = this.excludedExportsMonitor;
        synchronized (object) {
            this.removeExcludedPackages(partialManifest.getExportedPackages(), this.excludedExports);
        }
    }

    private void removeExcludedPackages(Set<String> packageNames, List<String> exclusions) {
        for (String packageName : new LinkedHashSet<String>(packageNames)) {
            if (!this.isExcluded(packageName, exclusions)) continue;
            packageNames.remove(packageName);
        }
    }

    private boolean isExcluded(String exportedPackage, List<String> exclusions) {
        for (String exclusion : exclusions) {
            if (!MatchUtils.matches(exportedPackage, exclusion)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getTemplateOnlyHeaderNames() {
        return Arrays.asList(ATTR_EXCLUDED_EXPORTS, ATTR_EXCLUDED_IMPORTS);
    }
}

