/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util.timeline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

public class CompactTimeline<Timestamp extends Comparable<Timestamp>>
extends Timeline<Timestamp> {
    protected final List<Timestamp> elements;

    CompactTimeline() {
        this.elements = new ArrayList<Timestamp>();
    }

    CompactTimeline(Timestamp timestamp) {
        this();
        this.elements.add(timestamp);
    }

    CompactTimeline(List<Timestamp> timestamps) {
        this.elements = new ArrayList<Timestamp>(timestamps.size());
        this.elements.addAll(timestamps);
    }

    CompactTimeline(Diff<Timestamp> diff) {
        this.elements = new ArrayList<Timestamp>(diff.size());
        Direction expected = Direction.INSERT;
        for (Signed signed : diff) {
            if (!expected.equals((Object)signed.getDirection())) {
                throw new IllegalStateException(String.format("Expected direction (%s) constraint violated! %s @%s", new Object[]{expected, diff, signed.getPayload()}));
            }
            this.elements.add(signed.getPayload());
            expected = expected.opposite();
        }
    }

    @Override
    public Signed<Timestamp> getSigned(int index) {
        Direction direction = index % 2 == 0 ? Direction.INSERT : Direction.DELETE;
        return new Signed<Timestamp>(direction, this.getUnsigned(index));
    }

    @Override
    public Timestamp getUnsigned(int index) {
        if (this.elements.size() <= index) {
            throw new IllegalArgumentException("Timeline size (" + this.size() + ") is smaller than requested index " + index + "!");
        }
        return (Timestamp)((Comparable)this.elements.get(index));
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isPresentAtInfinity() {
        return this.size() % 2 == 1;
    }

    @Override
    public Iterable<Signed<Timestamp>> asChangeSequence() {
        List<Timestamp> outer = this.elements;
        return () -> {
            final Iterator itr = outer.iterator();
            return new Iterator<Signed<Timestamp>>(){
                Direction direction = Direction.INSERT;

                @Override
                public boolean hasNext() {
                    return itr.hasNext();
                }

                @Override
                public Signed<Timestamp> next() {
                    Signed<Comparable> result = new Signed<Comparable>(this.direction, (Comparable)itr.next());
                    this.direction = this.direction.opposite();
                    return result;
                }
            };
        };
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }
}

