/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.AbstractTimelyTrivialMaskedMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

public final class TimelyNullaryMaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
extends AbstractTimelyTrivialMaskedMemory<Timestamp> {
    protected static final Tuple EMPTY_TUPLE = Tuples.staticArityFlatTupleOf();
    protected static final Set<Tuple> UNIT_RELATION = Collections.singleton(EMPTY_TUPLE);
    protected static final Set<Tuple> EMPTY_RELATION = Collections.emptySet();

    public TimelyNullaryMaskedTupleMemory(TupleMask mask, Object owner, boolean isLazy) {
        super(mask, owner, isLazy);
        if (mask.getSize() != 0) {
            throw new IllegalArgumentException(mask.toString());
        }
    }

    @Override
    public int getKeysetSize() {
        return this.memory.isEmpty() ? 0 : 1;
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return this.memory.isEmpty() ? EMPTY_RELATION : UNIT_RELATION;
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        if (signature.getSize() == 0) {
            return this.memory.getTuplesAtInfinity();
        }
        return null;
    }

    @Override
    public Map<Tuple, Timeline<Timestamp>> getWithTimeline(ITuple signature) {
        if (signature.getSize() == 0) {
            return this.memory.asMap();
        }
        return null;
    }

    @Override
    public Diff<Timestamp> removeWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        try {
            return this.memory.remove(tuple, timestamp);
        }
        catch (IllegalStateException e) {
            throw this.raiseDuplicateDeletion(tuple);
        }
    }

    @Override
    public Diff<Timestamp> addWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        return this.memory.put(tuple, timestamp);
    }

    @Override
    public boolean isPresentAtInfinity(ITuple signature) {
        if (signature.getSize() == 0) {
            return this.memory.getCountAtInfinity() > 0;
        }
        return false;
    }

    public Set<Tuple> getResumableSignatures() {
        if (this.memory.getResumableTimestamp() != null) {
            return UNIT_RELATION;
        }
        return EMPTY_RELATION;
    }

    @Override
    public Map<Tuple, Map<Tuple, Diff<Timestamp>>> resumeAt(Timestamp timestamp) {
        return Collections.singletonMap(EMPTY_TUPLE, this.memory.resumeAt(timestamp));
    }
}

