/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.aggregators;

import java.util.OptionalDouble;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.aggregators.AverageAccumulator;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;

public class IntegerAverageOperator
implements IMultisetAggregationOperator<Integer, AverageAccumulator<Integer>, Double> {
    public static final IntegerAverageOperator INSTANCE = new IntegerAverageOperator();

    private IntegerAverageOperator() {
    }

    @Override
    public String getShortDescription() {
        return "avg<Integer> incrementally computes the average of java.lang.Integer values";
    }

    @Override
    public String getName() {
        return "avg<Integer>";
    }

    @Override
    public AverageAccumulator<Integer> createNeutral() {
        return new AverageAccumulator<Integer>(0, 0L);
    }

    @Override
    public boolean isNeutral(AverageAccumulator<Integer> result) {
        return result.count == 0L;
    }

    @Override
    public AverageAccumulator<Integer> update(AverageAccumulator<Integer> oldResult, Integer updateValue, boolean isInsertion) {
        if (isInsertion) {
            oldResult.value = (Integer)oldResult.value + updateValue;
            ++oldResult.count;
        } else {
            oldResult.value = (Integer)oldResult.value - updateValue;
            --oldResult.count;
        }
        return oldResult;
    }

    @Override
    public Double getAggregate(AverageAccumulator<Integer> result) {
        return result.count == 0L ? null : Double.valueOf((double)((Integer)result.value).intValue() / (double)result.count);
    }

    @Override
    public Double aggregateStream(Stream<Integer> stream) {
        OptionalDouble averageOpt = stream.mapToInt(Integer::intValue).average();
        return averageOpt.isPresent() ? Double.valueOf(averageOpt.getAsDouble()) : null;
    }

    @Override
    public AverageAccumulator<Integer> clone(AverageAccumulator<Integer> original) {
        return new AverageAccumulator<Integer>((Integer)original.value, original.count);
    }
}

