/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.databinding.runtime.observables;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.viatra.addon.databinding.runtime.api.ViatraObservables;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class ObservableLabelFeature
extends ComputedValue {
    IPatternMatch match;
    String expression;
    Object container;
    final Map<String, IObservableValue> expressionMap;
    private List<String> expressionTokens;

    public ObservableLabelFeature(IPatternMatch match, String expression, Object container) {
        super(String.class);
        Preconditions.checkArgument((expression != null && !expression.isEmpty() ? 1 : 0) != 0, (String)"Expression must be set for label feature");
        this.match = match;
        this.expression = expression;
        this.container = container;
        this.expressionMap = this.initializeObservableMap(expression, match);
    }

    private final Map<String, IObservableValue> initializeObservableMap(String expression, IPatternMatch match) {
        HashMap<String, IObservableValue> map = new HashMap<String, IObservableValue>();
        StringTokenizer tokenizer = new StringTokenizer(expression, "$", false);
        boolean inExpression = false;
        boolean foundToken = false;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (token == null || token.isEmpty()) {
                if (inExpression && !foundToken) {
                    throw new IllegalArgumentException("Empty reference ($$) in message is not allowed.");
                }
                inExpression = !inExpression;
                continue;
            }
            if (!inExpression) continue;
            if (!map.containsKey(token)) {
                IObservableValue value = ViatraObservables.getObservableValue(match, token);
                map.put(token, value);
            }
            foundToken = true;
        }
        if (inExpression) {
            throw new IllegalArgumentException("Inconsistent model references - a $ character is missing.");
        }
        return map;
    }

    public Object getContainer() {
        return this.container;
    }

    public IPatternMatch getMatch() {
        return this.match;
    }

    public String getExpression() {
        return this.expression;
    }

    protected Object calculate() {
        StringBuilder sb = new StringBuilder();
        try {
            int i = 0;
            while (i < this.expressionTokens.size()) {
                String token = this.expressionTokens.get(i);
                if (i % 2 == 0) {
                    Preconditions.checkState((boolean)this.expressionMap.containsKey(token), (String)"Error while parsing expression %s", (Object[])new Object[]{token});
                    IObservableValue value = this.expressionMap.get(token);
                    sb.append(value.getValue());
                } else {
                    sb.append(token);
                }
                ++i;
            }
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
        return sb.toString();
    }

    public synchronized void dispose() {
        for (Map.Entry<String, IObservableValue> entry : this.expressionMap.entrySet()) {
            entry.getValue().dispose();
        }
        this.expressionMap.clear();
        super.dispose();
    }
}

